/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.server.session;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.server.session.DeviceSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ChildrenDeviceSession
implements DeviceSession {
    private static final Logger log = LoggerFactory.getLogger(ChildrenDeviceSession.class);
    private final String id;
    private final String deviceId;
    private final DeviceSession parent;
    private final DeviceOperator operator;
    private List<Runnable> closeListener;
    private long lastKeepAliveTime;
    private long keepAliveTimeOutMs = -1L;

    public ChildrenDeviceSession(String deviceId, DeviceSession parent, DeviceOperator operator) {
        this.id = deviceId;
        this.parent = parent;
        this.operator = operator;
        this.deviceId = deviceId;
        this.lastKeepAliveTime = parent.lastPingTime();
    }

    @Override
    public long lastPingTime() {
        return this.lastKeepAliveTime;
    }

    @Override
    public long connectTime() {
        return this.parent.connectTime();
    }

    @Override
    public Mono<Boolean> send(EncodedMessage encodedMessage) {
        log.info("send child device[{}:{}] message", (Object)this.parent.getDeviceId(), (Object)this.deviceId);
        return this.parent.send(encodedMessage);
    }

    @Override
    public Transport getTransport() {
        return this.parent.getTransport();
    }

    @Override
    public void close() {
        if (null != this.closeListener) {
            this.closeListener.forEach(Runnable::run);
        }
    }

    @Override
    public void ping() {
        this.parent.ping();
        this.lastKeepAliveTime = System.currentTimeMillis();
    }

    @Override
    public boolean isAlive() {
        if (this.keepAliveTimeOutMs <= 0L) {
            return this.parent.isAlive();
        }
        return System.currentTimeMillis() - this.lastKeepAliveTime < this.keepAliveTimeOutMs && this.parent.isAlive();
    }

    @Override
    public synchronized void onClose(Runnable call) {
        if (this.closeListener == null) {
            this.closeListener = new CopyOnWriteArrayList<Runnable>();
        }
        this.closeListener.add(call);
    }

    @Override
    public Optional<String> getServerId() {
        return this.parent.getServerId();
    }

    @Override
    public boolean isWrapFrom(Class<?> type) {
        return type == ChildrenDeviceSession.class || this.parent.isWrapFrom(type);
    }

    @Override
    public Optional<InetSocketAddress> getClientAddress() {
        return this.parent.getClientAddress();
    }

    @Override
    public void setKeepAliveTimeout(Duration timeout) {
        this.keepAliveTimeOutMs = timeout.toMillis();
    }

    @Override
    public Duration getKeepAliveTimeout() {
        return Duration.ofMillis(this.keepAliveTimeOutMs);
    }

    @Override
    public <T extends DeviceSession> T unwrap(Class<T> type) {
        return (T)(type == ChildrenDeviceSession.class ? (DeviceSession)type.cast(this) : this.parent.unwrap(type));
    }

    public String toString() {
        return "children device[" + this.deviceId + "] in " + this.parent;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public DeviceOperator getOperator() {
        return this.operator;
    }
}

