/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.server.session;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nullable;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.Transport;
import reactor.core.publisher.Mono;

public interface DeviceSession {
    public String getId();

    public String getDeviceId();

    @Nullable
    public DeviceOperator getOperator();

    public long lastPingTime();

    public long connectTime();

    public Mono<Boolean> send(EncodedMessage var1);

    public Transport getTransport();

    public void close();

    public void ping();

    public boolean isAlive();

    public void onClose(Runnable var1);

    default public Optional<String> getServerId() {
        return Optional.empty();
    }

    default public Optional<InetSocketAddress> getClientAddress() {
        return Optional.empty();
    }

    default public void keepAlive() {
        this.ping();
    }

    default public void setKeepAliveTimeout(Duration timeout) {
    }

    default public Duration getKeepAliveTimeout() {
        return Duration.ZERO;
    }

    default public boolean isWrapFrom(Class<?> type) {
        return type.isInstance(this);
    }

    default public <T extends DeviceSession> T unwrap(Class<T> type) {
        return (T)((DeviceSession)type.cast(this));
    }
}

