/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.server.session;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.time.Duration;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.server.session.DeviceSessionProvider;
import org.jetlinks.core.server.session.DeviceSessionProviders;
import org.jetlinks.core.server.session.KeepOnlineSession;
import org.jetlinks.core.server.session.LostDeviceSession;
import org.jetlinks.core.server.session.PersistentSession;
import reactor.core.publisher.Mono;

class KeepOnlineDeviceSessionProvider
implements DeviceSessionProvider {
    static final String ID = "keep_online";
    static final KeepOnlineDeviceSessionProvider INSTANCE = new KeepOnlineDeviceSessionProvider();

    KeepOnlineDeviceSessionProvider() {
    }

    public static void load() {
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public Mono<PersistentSession> deserialize(byte[] sessionData, DeviceRegistry registry) {
        JSONObject data = (JSONObject)JSON.parseObject((byte[])sessionData, JSONObject.class, (Feature[])new Feature[0]);
        String deviceId = data.getString("deviceId");
        return registry.getDevice(deviceId).map(device -> {
            String id = data.getString("id");
            String transport = data.getString("transport");
            long timeout = data.getLongValue("timeout");
            long lstTime = data.getLongValue("lstTime");
            KeepOnlineSession session = new KeepOnlineSession(new LostDeviceSession(id, (DeviceOperator)device, Transport.of(transport)), Duration.ofMillis(timeout));
            session.setLastKeepAliveTime(lstTime);
            return session;
        });
    }

    @Override
    public Mono<byte[]> serialize(PersistentSession session, DeviceRegistry registry) {
        JSONObject data = new JSONObject();
        data.put("id", (Object)session.getId());
        data.put("deviceId", (Object)session.getDeviceId());
        data.put("timeout", (Object)session.getKeepAliveTimeout().toMillis());
        data.put("lstTime", (Object)session.lastPingTime());
        data.put("transport", (Object)session.getTransport().getId());
        return Mono.just((Object)JSON.toJSONBytes((Object)data, (SerializerFeature[])new SerializerFeature[0]));
    }

    static {
        DeviceSessionProviders.register(INSTANCE);
    }
}

