/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.server.session;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nullable;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.exception.DeviceOperationException;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.server.session.DeviceSession;
import org.jetlinks.core.server.session.PersistentSession;
import org.jetlinks.core.server.session.ReplaceableDeviceSession;
import reactor.core.publisher.Mono;

public class KeepOnlineSession
implements DeviceSession,
ReplaceableDeviceSession,
PersistentSession {
    DeviceSession parent;
    private long lastKeepAliveTime = System.currentTimeMillis();
    private final long connectTime = System.currentTimeMillis();
    private long keepAliveTimeOutMs;

    public KeepOnlineSession(DeviceSession parent, Duration keepAliveTimeOut) {
        this.parent = parent;
        this.setKeepAliveTimeout(keepAliveTimeOut);
    }

    @Override
    public String getId() {
        return this.parent.getId();
    }

    @Override
    public String getDeviceId() {
        return this.parent.getDeviceId();
    }

    @Override
    @Nullable
    public DeviceOperator getOperator() {
        return this.parent.getOperator();
    }

    @Override
    public long lastPingTime() {
        return this.lastKeepAliveTime;
    }

    @Override
    public long connectTime() {
        return this.connectTime;
    }

    @Override
    public Mono<Boolean> send(EncodedMessage encodedMessage) {
        return Mono.defer(() -> {
            if (this.parent.isAlive()) {
                return this.parent.send(encodedMessage);
            }
            return Mono.error((Throwable)new DeviceOperationException(ErrorCode.CONNECTION_LOST));
        });
    }

    @Override
    public Transport getTransport() {
        return this.parent.getTransport();
    }

    @Override
    public void close() {
        this.parent.close();
    }

    @Override
    public void ping() {
        this.lastKeepAliveTime = System.currentTimeMillis();
        this.parent.keepAlive();
    }

    @Override
    public boolean isAlive() {
        return this.keepAliveTimeOutMs <= 0L || System.currentTimeMillis() - this.lastKeepAliveTime < this.keepAliveTimeOutMs || this.parent.isAlive();
    }

    @Override
    public void onClose(Runnable call) {
        this.parent.onClose(call);
    }

    @Override
    public Optional<String> getServerId() {
        return this.parent.getServerId();
    }

    @Override
    public Optional<InetSocketAddress> getClientAddress() {
        return this.parent.getClientAddress();
    }

    @Override
    public void setKeepAliveTimeout(Duration timeout) {
        this.keepAliveTimeOutMs = timeout.toMillis();
        this.parent.setKeepAliveTimeout(timeout);
    }

    @Override
    public Duration getKeepAliveTimeout() {
        return Duration.ofMillis(this.keepAliveTimeOutMs);
    }

    @Override
    public boolean isWrapFrom(Class<?> type) {
        return type == KeepOnlineSession.class || this.parent.isWrapFrom(type);
    }

    @Override
    public <T extends DeviceSession> T unwrap(Class<T> type) {
        return (T)(type == KeepOnlineSession.class ? (DeviceSession)type.cast(this) : this.parent.unwrap(type));
    }

    @Override
    public void replaceWith(DeviceSession session) {
        this.parent = session;
    }

    @Override
    public String getProvider() {
        return "keep_online";
    }

    void setLastKeepAliveTime(long lastKeepAliveTime) {
        this.lastKeepAliveTime = lastKeepAliveTime;
    }
}

