/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.topic;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetlinks.core.cache.Caches;
import org.jetlinks.core.utils.TopicUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public final class Topic<T> {
    private final Topic<T> parent;
    private String part;
    private volatile String topic;
    private volatile String[] topics;
    private final int depth;
    private final ConcurrentMap<String, Topic<T>> child = Caches.newCache();
    private final ConcurrentMap<T, AtomicInteger> subscribers = Caches.newCache();
    private static final AntPathMatcher matcher = new AntPathMatcher(){

        protected String[] tokenizePath(String path) {
            return TopicUtils.split(path);
        }
    };

    public static <T> Topic<T> createRoot() {
        return new Topic<T>(null, "/");
    }

    public Topic<T> append(String topic) {
        if (topic.equals("/") || topic.equals("")) {
            return this;
        }
        return this.getOrDefault(topic, Topic::new);
    }

    private Topic(Topic<T> parent, String part) {
        if (StringUtils.isEmpty((Object)part) || part.equals("/")) {
            this.part = "";
        } else if (part.contains("/")) {
            this.ofTopic(part);
        } else {
            this.part = part;
        }
        this.parent = parent;
        this.depth = null != parent ? parent.depth + 1 : 0;
    }

    public String[] getTopics() {
        if (this.topics != null) {
            return this.topics;
        }
        this.topics = TopicUtils.split(this.getTopic());
        return this.topics;
    }

    public String getTopic() {
        if (this.topic == null) {
            Topic<T> parent = this.getParent();
            StringBuilder builder = new StringBuilder();
            if (parent != null) {
                String parentTopic = parent.getTopic();
                builder.append(parentTopic).append(parentTopic.equals("/") ? "" : "/");
            } else {
                builder.append("/");
            }
            this.topic = builder.append(this.part).toString();
            return this.topic;
        }
        return this.topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getSubscriberOrSubscribe(Supplier<T> supplier) {
        if (this.subscribers.size() > 0) {
            return (T)this.subscribers.keySet().iterator().next();
        }
        Topic topic = this;
        synchronized (topic) {
            if (this.subscribers.size() > 0) {
                return (T)this.subscribers.keySet().iterator().next();
            }
            T sub = supplier.get();
            this.subscribe(sub);
            return sub;
        }
    }

    public Set<T> getSubscribers() {
        return this.subscribers.keySet();
    }

    public boolean subscribed(T subscriber) {
        return this.subscribers.containsKey(subscriber);
    }

    @SafeVarargs
    public final void subscribe(T ... subscribers) {
        for (T subscriber : subscribers) {
            this.subscribers.computeIfAbsent(subscriber, i -> new AtomicInteger()).incrementAndGet();
        }
    }

    @SafeVarargs
    public final List<T> unsubscribe(T ... subscribers) {
        ArrayList unsub = new ArrayList();
        for (T subscriber : subscribers) {
            this.subscribers.computeIfPresent(subscriber, (k, v) -> {
                if (v.decrementAndGet() <= 0) {
                    unsub.add(k);
                    return null;
                }
                return v;
            });
        }
        return unsub;
    }

    public final void unsubscribe(Predicate<T> predicate) {
        for (Map.Entry entry : this.subscribers.entrySet()) {
            if (!predicate.test(entry.getKey()) || ((AtomicInteger)entry.getValue()).decrementAndGet() > 0) continue;
            this.subscribers.remove(entry.getKey());
        }
    }

    public final void unsubscribeAll() {
        this.subscribers.clear();
    }

    public Collection<Topic<T>> getChildren() {
        return this.child.values();
    }

    private void ofTopic(String topic) {
        String[] parts = topic.split("/", 2);
        this.part = parts[0];
        if (parts.length > 1) {
            Topic<T> part = new Topic<T>(this, parts[1]);
            this.child.put(part.part, part);
        }
    }

    private Topic<T> getOrDefault(String topic, BiFunction<Topic<T>, String, Topic<T>> mapping) {
        if (topic.startsWith("/")) {
            topic = topic.substring(1);
        }
        String[] parts = topic.split("/");
        Topic part = this.child.computeIfAbsent(parts[0], _topic -> (Topic)mapping.apply(this, (String)_topic));
        for (int i = 1; i < parts.length && part != null; ++i) {
            Topic parent = part;
            part = part.child.computeIfAbsent(parts[i], _topic -> (Topic)mapping.apply(parent, (String)_topic));
        }
        return part;
    }

    public Optional<Topic<T>> getTopic(String topic) {
        return Optional.ofNullable(this.getOrDefault(topic, (topicPart, s) -> null));
    }

    public Flux<Topic<T>> findTopic(String topic) {
        if (!topic.startsWith("/")) {
            topic = "/" + topic;
        }
        return Topic.find(topic, this);
    }

    public String toString() {
        return "topic: " + this.getTopic() + ", subscribers: " + this.subscribers.size() + ", children: " + this.child.size();
    }

    protected boolean match(String[] pars) {
        return TopicUtils.match(this.getTopics(), pars) || TopicUtils.match(pars, this.getTopics());
    }

    public static <T> Flux<Topic<T>> find(String topic, Topic<T> topicPart) {
        return Flux.create(sink -> {
            Topic part;
            ArrayDeque<Topic> cache = new ArrayDeque<Topic>(128);
            cache.add(topicPart);
            String[] topicParts = TopicUtils.split(topic);
            String nextPart = null;
            while (!cache.isEmpty() && !sink.isCancelled() && (part = (Topic)cache.poll()) != null) {
                if (part.match(topicParts)) {
                    sink.next((Object)part);
                }
                if (part.part.equals("**")) {
                    Topic tmp = null;
                    for (int i = part.depth; i < topicParts.length; ++i) {
                        tmp = (Topic)part.child.get(topicParts[i]);
                        if (tmp == null) continue;
                        cache.add(tmp);
                    }
                    if (null != tmp) continue;
                }
                if ("**".equals(nextPart) || "*".equals(nextPart)) {
                    cache.addAll(part.child.values());
                    continue;
                }
                Topic next = (Topic)part.child.get("**");
                if (next != null) {
                    cache.add(next);
                }
                if ((next = (Topic)part.child.get("*")) != null) {
                    cache.add(next);
                }
                if (part.depth + 1 >= topicParts.length) continue;
                nextPart = topicParts[part.depth + 1];
                if (nextPart.equals("*") || nextPart.equals("**")) {
                    cache.addAll(part.child.values());
                    continue;
                }
                next = (Topic)part.child.get(nextPart);
                if (next == null) continue;
                cache.add(next);
            }
            sink.complete();
        });
    }

    public long getTotalTopic() {
        long total = this.child.size();
        for (Topic<T> tTopic : this.getChildren()) {
            total += tTopic.getTotalTopic();
        }
        return total;
    }

    public long getTotalSubscriber() {
        long total = this.subscribers.size();
        for (Topic<T> tTopic : this.getChildren()) {
            total += tTopic.getTotalTopic();
        }
        return total;
    }

    public Flux<Topic<T>> getAllSubscriber() {
        ArrayList<Object> all = new ArrayList<Object>();
        all.add(Flux.fromIterable(this.getChildren()));
        for (Topic<T> tTopic : this.getChildren()) {
            all.add(tTopic.getAllSubscriber());
        }
        return Flux.concat(all);
    }

    public void clean() {
        this.unsubscribeAll();
        this.getChildren().forEach(Topic::clean);
        this.child.clear();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Topic)) {
            return false;
        }
        Topic other = (Topic)o;
        String this$part = this.part;
        String other$part = other.part;
        return !(this$part == null ? other$part != null : !this$part.equals(other$part));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $part = this.part;
        result = result * 59 + ($part == null ? 43 : $part.hashCode());
        return result;
    }

    public Topic<T> getParent() {
        return this.parent;
    }

    private void setPart(String part) {
        this.part = part;
    }

    private void setTopic(String topic) {
        this.topic = topic;
    }

    private void setTopics(String[] topics) {
        this.topics = topics;
    }

    static {
        matcher.setCachePatterns(true);
        matcher.setCaseSensitive(true);
    }
}

