/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class TopicUtils {
    private static final PathMatcher pathMatcher = new AntPathMatcher();

    public static boolean match(String pattern, String topic) {
        if (pattern.equals(topic)) {
            return true;
        }
        if (!(pattern.contains("*") || pattern.contains("#") || pattern.contains("+") || pattern.contains("{"))) {
            return false;
        }
        return pathMatcher.match(pattern.replace("#", "**").replace("+", "*"), topic);
    }

    public static Map<String, String> getPathVariables(String template, String topic) {
        try {
            return pathMatcher.extractUriTemplateVariables(template, topic);
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    public static String[] split(String topic) {
        return topic.split("/");
    }

    private static boolean matchStrings(String str, String pattern) {
        return str.equals(pattern) || "*".equals(pattern) || "*".equals(str);
    }

    public static boolean match(String[] pattern, String[] topicParts) {
        String pattDir;
        int pathIdxStart;
        if (pattern.length == 0 && topicParts.length == 0) {
            return true;
        }
        int pattIdxStart = 0;
        int pattIdxEnd = pattern.length - 1;
        int pathIdxEnd = topicParts.length - 1;
        for (pathIdxStart = 0; pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !"**".equals(pattDir = pattern[pattIdxStart]); ++pattIdxStart, ++pathIdxStart) {
            if (TopicUtils.matchStrings(pattDir, topicParts[pathIdxStart])) continue;
            return false;
        }
        if (pathIdxStart > pathIdxEnd) {
            if (pattIdxStart > pattIdxEnd) {
                return pattern[pattern.length - 1].equals("/") == topicParts[topicParts.length - 1].equals("/");
            }
            if (pattIdxStart == pattIdxEnd && pattern[pattIdxStart].equals("*") && topicParts[topicParts.length - 1].equals("/")) {
                return true;
            }
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattern[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        if (pattIdxStart > pattIdxEnd) {
            return false;
        }
        if ("**".equals(topicParts[pattIdxStart])) {
            return true;
        }
        while (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !(pattDir = pattern[pattIdxEnd]).equals("**")) {
            if (!TopicUtils.matchStrings(pattDir, topicParts[pathIdxEnd])) {
                return false;
            }
            --pattIdxEnd;
            --pathIdxEnd;
        }
        if (pathIdxStart > pathIdxEnd) {
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattern[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        while (pattIdxStart != pattIdxEnd && pathIdxStart <= pathIdxEnd) {
            int patIdxTmp = -1;
            for (int i = pattIdxStart + 1; i <= pattIdxEnd; ++i) {
                if (!pattern[i].equals("**")) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == pattIdxStart + 1) {
                ++pattIdxStart;
                continue;
            }
            int patLength = patIdxTmp - pattIdxStart - 1;
            int strLength = pathIdxEnd - pathIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subPat = pattern[pattIdxStart + j + 1];
                    String subStr = topicParts[pathIdxStart + i + j];
                    if (!TopicUtils.matchStrings(subPat, subStr)) continue block6;
                }
                foundIdx = pathIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            pattIdxStart = patIdxTmp;
            pathIdxStart = foundIdx + patLength;
        }
        for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
            if (pattern[i].equals("**")) continue;
            return false;
        }
        return true;
    }

    public static List<String> expand(String topic) {
        if (!topic.contains(",")) {
            return Collections.singletonList(topic);
        }
        if (topic.startsWith("/")) {
            topic = topic.substring(1);
        }
        String[] parts = topic.split("/", 2);
        String first = parts[0];
        ArrayList<String> expands = new ArrayList<String>();
        if (parts.length == 1) {
            for (String split : first.split(",")) {
                expands.add("/" + split);
            }
            return expands;
        }
        List<String> nextTopics = TopicUtils.expand(parts[1]);
        for (String split : first.split(",")) {
            for (String nextTopic : nextTopics) {
                StringJoiner joiner = new StringJoiner("");
                joiner.add("/");
                joiner.add(split);
                if (!nextTopic.startsWith("/")) {
                    joiner.add("/");
                }
                joiner.add(nextTopic);
                expands.add(joiner.toString());
            }
        }
        return expands;
    }
}

