/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.util.Optional;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.api.condition.MethodBasedCondition;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

class EnabledIfCondition
extends MethodBasedCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled("@EnabledIf is not present");
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled("Condition provided in @EnabledIf evaluates to true");
    private static final ConditionEvaluationResult DISABLED = ConditionEvaluationResult.disabled("Condition provided in @EnabledIf evaluates to false");

    EnabledIfCondition() {
    }

    @Override
    Optional<String> getMethodName(ExtensionContext context) {
        return AnnotationUtils.findAnnotation(context.getElement(), EnabledIf.class).map(EnabledIf::value);
    }

    @Override
    ConditionEvaluationResult getDefaultResult() {
        return ENABLED_BY_DEFAULT;
    }

    @Override
    ConditionEvaluationResult getResultBasedOnBoolean(boolean result) {
        return result ? ENABLED : DISABLED;
    }
}

