/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.AssertionFailureBuilder;

class AssertInstanceOf {
    private AssertInstanceOf() {
    }

    static <T> T assertInstanceOf(Class<T> expectedType, @Nullable Object actualValue) {
        return AssertInstanceOf.assertInstanceOf(expectedType, actualValue, null);
    }

    static <T> T assertInstanceOf(Class<T> expectedType, @Nullable Object actualValue, @Nullable String message) {
        return AssertInstanceOf.assertInstanceOf(expectedType, actualValue, (Object)message);
    }

    static <T> T assertInstanceOf(Class<T> expectedType, @Nullable Object actualValue, Supplier<@Nullable String> messageSupplier) {
        return AssertInstanceOf.assertInstanceOf(expectedType, actualValue, messageSupplier);
    }

    private static <T> T assertInstanceOf(Class<T> expectedType, @Nullable Object actualValue, @Nullable Object messageOrSupplier) {
        if (!expectedType.isInstance(actualValue)) {
            AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).reason(actualValue == null ? "Unexpected null value" : "Unexpected type").expected(expectedType).actual(actualValue == null ? null : actualValue.getClass()).buildAndThrow();
        }
        return expectedType.cast(actualValue);
    }
}

