/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.extension;

import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.commons.util.ToStringBuilder;

@API(status=API.Status.STABLE, since="5.0")
public class ConditionEvaluationResult {
    private final boolean enabled;
    private final Optional<String> reason;

    public static ConditionEvaluationResult enabled(String reason) {
        return new ConditionEvaluationResult(true, reason);
    }

    public static ConditionEvaluationResult disabled(String reason) {
        return new ConditionEvaluationResult(false, reason);
    }

    @API(status=API.Status.STABLE, since="5.7")
    public static ConditionEvaluationResult disabled(String reason, String customReason) {
        if (StringUtils.isBlank((String)customReason)) {
            return ConditionEvaluationResult.disabled(reason);
        }
        return ConditionEvaluationResult.disabled("%s ==> %s".formatted(reason, customReason));
    }

    private ConditionEvaluationResult(boolean enabled, String reason) {
        this.enabled = enabled;
        this.reason = Optional.ofNullable(reason);
    }

    public boolean isDisabled() {
        return !this.enabled;
    }

    public Optional<String> getReason() {
        return this.reason;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("enabled", (Object)this.enabled).append("reason", (Object)this.reason.orElse("<unknown>")).toString();
    }
}

