/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.opentest4j.AssertionFailedError;

class AssertDoesNotThrow {
    private AssertDoesNotThrow() {
    }

    static void assertDoesNotThrow(Executable executable) {
        AssertDoesNotThrow.assertDoesNotThrow(executable, null);
    }

    static void assertDoesNotThrow(Executable executable, @Nullable String message) {
        AssertDoesNotThrow.assertDoesNotThrow(executable, (Object)message);
    }

    static void assertDoesNotThrow(Executable executable, Supplier<@Nullable String> messageSupplier) {
        AssertDoesNotThrow.assertDoesNotThrow(executable, messageSupplier);
    }

    private static void assertDoesNotThrow(Executable executable, @Nullable Object messageOrSupplier) {
        try {
            executable.execute();
        }
        catch (Throwable t) {
            UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)t);
            throw AssertDoesNotThrow.createAssertionFailedError(messageOrSupplier, t);
        }
    }

    static <T> T assertDoesNotThrow(ThrowingSupplier<T> supplier) {
        return AssertDoesNotThrow.assertDoesNotThrow(supplier, null);
    }

    static <T> T assertDoesNotThrow(ThrowingSupplier<T> supplier, @Nullable String message) {
        return AssertDoesNotThrow.assertDoesNotThrow(supplier, (Object)message);
    }

    static <T> T assertDoesNotThrow(ThrowingSupplier<T> supplier, Supplier<@Nullable String> messageSupplier) {
        return AssertDoesNotThrow.assertDoesNotThrow(supplier, messageSupplier);
    }

    private static <T> T assertDoesNotThrow(ThrowingSupplier<T> supplier, @Nullable Object messageOrSupplier) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)t);
            throw AssertDoesNotThrow.createAssertionFailedError(messageOrSupplier, t);
        }
    }

    @API(status=API.Status.INTERNAL, since="6.0")
    public static AssertionFailedError createAssertionFailedError(@Nullable Object messageOrSupplier, Throwable t) {
        return AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).reason("Unexpected exception thrown: " + t.getClass().getName() + AssertDoesNotThrow.buildSuffix(t.getMessage())).cause(t).build();
    }

    private static String buildSuffix(@Nullable String message) {
        return StringUtils.isNotBlank((String)message) ? ": " + message : "";
    }
}

