/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Timeout;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;

record TimeoutDuration(long value, TimeUnit unit) {
    TimeoutDuration(long value, TimeUnit unit) {
        Preconditions.condition((value > 0L ? 1 : 0) != 0, () -> "timeout duration must be a positive number: " + value);
        this.value = value;
        this.unit = (TimeUnit)((Object)Preconditions.notNull((Object)((Object)unit), (String)"timeout unit must not be null"));
    }

    static TimeoutDuration from(Timeout timeout) {
        return new TimeoutDuration(timeout.value(), timeout.unit());
    }

    @Override
    public String toString() {
        String label = this.unit.name().toLowerCase();
        if (this.value == 1L && label.endsWith("s")) {
            label = label.substring(0, label.length() - 1);
        }
        return this.value + " " + label;
    }

    public Duration toDuration() {
        return Duration.of(this.value, this.toChronoUnit());
    }

    private ChronoUnit toChronoUnit() {
        return switch (this.unit) {
            case TimeUnit.NANOSECONDS -> ChronoUnit.NANOS;
            case TimeUnit.MICROSECONDS -> ChronoUnit.MICROS;
            case TimeUnit.MILLISECONDS -> ChronoUnit.MILLIS;
            case TimeUnit.SECONDS -> ChronoUnit.SECONDS;
            case TimeUnit.MINUTES -> ChronoUnit.MINUTES;
            case TimeUnit.HOURS -> ChronoUnit.HOURS;
            case TimeUnit.DAYS -> ChronoUnit.DAYS;
            default -> throw new JUnitException("Could not map TimeUnit " + String.valueOf((Object)this.unit) + " to ChronoUnit");
        };
    }
}

