/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.ParameterizedTestInvocationContext;
import org.junit.jupiter.params.ParameterizedTestMethodContext;
import org.junit.jupiter.params.ParameterizedTestNameFormatter;
import org.junit.jupiter.params.ParameterizedTestSpiInstantiator;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.support.AnnotationConsumerInitializer;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;

class ParameterizedTestExtension
implements TestTemplateInvocationContextProvider {
    static final String METHOD_CONTEXT_KEY = "context";
    static final String ARGUMENT_MAX_LENGTH_KEY = "junit.jupiter.params.displayname.argument.maxlength";
    static final String DEFAULT_DISPLAY_NAME = "{default_display_name}";
    static final String DISPLAY_NAME_PATTERN_KEY = "junit.jupiter.params.displayname.default";

    ParameterizedTestExtension() {
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        if (!context.getTestMethod().isPresent()) {
            return false;
        }
        Method templateMethod = (Method)context.getTestMethod().get();
        Optional annotation = AnnotationSupport.findAnnotation((AnnotatedElement)templateMethod, ParameterizedTest.class);
        if (!annotation.isPresent()) {
            return false;
        }
        ParameterizedTestMethodContext methodContext = new ParameterizedTestMethodContext(templateMethod, (ParameterizedTest)annotation.get());
        Preconditions.condition((boolean)methodContext.hasPotentiallyValidSignature(), () -> String.format("@ParameterizedTest method [%s] declares formal parameters in an invalid order: argument aggregators must be declared after any indexed arguments and before any arguments resolved by another ParameterResolver.", templateMethod.toGenericString()));
        this.getStore(context).put((Object)METHOD_CONTEXT_KEY, (Object)methodContext);
        return true;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext extensionContext) {
        ParameterizedTestMethodContext methodContext = this.getMethodContext(extensionContext);
        ParameterizedTestNameFormatter formatter = this.createNameFormatter(extensionContext, methodContext);
        AtomicLong invocationCount = new AtomicLong(0L);
        List argumentsSources = AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)methodContext.method, ArgumentsSource.class);
        Preconditions.notEmpty((Collection)argumentsSources, (String)"Configuration error: You must configure at least one arguments source for this @ParameterizedTest");
        return (Stream)argumentsSources.stream().map(ArgumentsSource::value).map(clazz -> ParameterizedTestSpiInstantiator.instantiate(ArgumentsProvider.class, clazz, extensionContext)).map(provider -> AnnotationConsumerInitializer.initialize(methodContext.method, provider)).flatMap(provider -> ParameterizedTestExtension.arguments(provider, extensionContext)).map(arguments -> {
            invocationCount.incrementAndGet();
            return this.createInvocationContext(formatter, methodContext, (Arguments)arguments, invocationCount.intValue());
        }).onClose(() -> Preconditions.condition((invocationCount.get() > 0L || methodContext.annotation.allowZeroInvocations() ? 1 : 0) != 0, (String)"Configuration error: You must configure at least one set of arguments for this @ParameterizedTest"));
    }

    public boolean mayReturnZeroTestTemplateInvocationContexts(ExtensionContext extensionContext) {
        ParameterizedTestMethodContext methodContext = this.getMethodContext(extensionContext);
        return methodContext.annotation.allowZeroInvocations();
    }

    private ParameterizedTestMethodContext getMethodContext(ExtensionContext extensionContext) {
        return (ParameterizedTestMethodContext)this.getStore(extensionContext).get((Object)METHOD_CONTEXT_KEY, ParameterizedTestMethodContext.class);
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{ParameterizedTestExtension.class, context.getRequiredTestMethod()}));
    }

    private TestTemplateInvocationContext createInvocationContext(ParameterizedTestNameFormatter formatter, ParameterizedTestMethodContext methodContext, Arguments arguments, int invocationIndex) {
        return new ParameterizedTestInvocationContext(formatter, methodContext, arguments, invocationIndex);
    }

    private ParameterizedTestNameFormatter createNameFormatter(ExtensionContext extensionContext, ParameterizedTestMethodContext methodContext) {
        String name = methodContext.annotation.name();
        String pattern = name.equals(DEFAULT_DISPLAY_NAME) ? extensionContext.getConfigurationParameter(DISPLAY_NAME_PATTERN_KEY).orElse("[{index}] {argumentSetNameOrArgumentsWithNames}") : name;
        pattern = Preconditions.notBlank((String)pattern.trim(), () -> String.format("Configuration error: @ParameterizedTest on method [%s] must be declared with a non-empty name.", methodContext.method));
        int argumentMaxLength = extensionContext.getConfigurationParameter(ARGUMENT_MAX_LENGTH_KEY, Integer::parseInt).orElse(512);
        return new ParameterizedTestNameFormatter(pattern, extensionContext.getDisplayName(), methodContext, argumentMaxLength);
    }

    protected static Stream<? extends Arguments> arguments(ArgumentsProvider provider, ExtensionContext context) {
        try {
            return provider.provideArguments(context);
        }
        catch (Exception e) {
            throw ExceptionUtils.throwAsUncheckedException((Throwable)e);
        }
    }
}

