/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstantiationAwareExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.ParameterizedTestMethodContext;
import org.junit.platform.commons.support.AnnotationSupport;

class ParameterizedTestParameterResolver
implements ParameterResolver,
AfterTestExecutionCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{ParameterizedTestParameterResolver.class});
    private final ParameterizedTestMethodContext methodContext;
    private final Object[] arguments;
    private final int invocationIndex;

    ParameterizedTestParameterResolver(ParameterizedTestMethodContext methodContext, Object[] arguments, int invocationIndex) {
        this.methodContext = methodContext;
        this.arguments = arguments;
        this.invocationIndex = invocationIndex;
    }

    public TestInstantiationAwareExtension.ExtensionContextScope getTestInstantiationExtensionContextScope(ExtensionContext rootContext) {
        return TestInstantiationAwareExtension.ExtensionContextScope.TEST_METHOD;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Executable declaringExecutable = parameterContext.getDeclaringExecutable();
        Method testMethod = extensionContext.getTestMethod().orElse(null);
        int parameterIndex = parameterContext.getIndex();
        if (!declaringExecutable.equals(testMethod)) {
            return false;
        }
        if (this.methodContext.isAggregator(parameterIndex)) {
            return true;
        }
        if (this.methodContext.hasAggregator()) {
            return parameterIndex < this.methodContext.indexOfFirstAggregator();
        }
        return parameterIndex < this.arguments.length;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.methodContext.resolve(parameterContext, extensionContext, this.extractPayloads(this.arguments), this.invocationIndex);
    }

    public void afterTestExecution(ExtensionContext context) {
        ParameterizedTest parameterizedTest = (ParameterizedTest)AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestMethod(), ParameterizedTest.class).get();
        if (!parameterizedTest.autoCloseArguments()) {
            return;
        }
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        AtomicInteger argumentIndex = new AtomicInteger();
        Arrays.stream(this.arguments).filter(AutoCloseable.class::isInstance).map(AutoCloseable.class::cast).map(CloseableArgument::new).forEach(closeable -> store.put((Object)("closeableArgument#" + argumentIndex.incrementAndGet()), closeable));
    }

    private Object[] extractPayloads(Object[] arguments) {
        return Arrays.stream(arguments).map(argument -> {
            if (argument instanceof Named) {
                return ((Named)argument).getPayload();
            }
            return argument;
        }).toArray();
    }

    private static class CloseableArgument
    implements ExtensionContext.Store.CloseableResource {
        private final AutoCloseable autoCloseable;

        CloseableArgument(AutoCloseable autoCloseable) {
            this.autoCloseable = autoCloseable;
        }

        public void close() throws Throwable {
            this.autoCloseable.close();
        }
    }
}

