/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.AnnotationBasedArgumentsProvider;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvParsingException;
import org.junit.jupiter.params.provider.CsvReaderFactory;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvReader;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvRecord;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.NamedCsvRecord;
import org.junit.jupiter.params.support.ParameterDeclarations;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.UnrecoverableExceptions;

class CsvArgumentsProvider
extends AnnotationBasedArgumentsProvider<CsvSource> {
    CsvArgumentsProvider() {
    }

    @Override
    protected Stream<? extends Arguments> provideArguments(ParameterDeclarations parameters, ExtensionContext context, CsvSource csvSource) {
        CsvReaderFactory.validate(csvSource);
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        try (CsvReader<? extends CsvRecord> reader = CsvReaderFactory.createReaderFor(csvSource, CsvArgumentsProvider.getData(csvSource));){
            boolean useHeadersInDisplayName = csvSource.useHeadersInDisplayName();
            for (CsvRecord csvRecord : reader) {
                arguments.add(CsvArgumentsProvider.processCsvRecord(csvRecord, useHeadersInDisplayName));
            }
        }
        catch (Throwable throwable) {
            throw CsvArgumentsProvider.handleCsvException(throwable, csvSource);
        }
        return arguments.stream();
    }

    private static String getData(CsvSource csvSource) {
        CharSequence[] values = csvSource.value();
        Preconditions.condition((boolean)(values.length > 0 ^ !csvSource.textBlock().isEmpty()), () -> "@CsvSource must be declared with either `value` or `textBlock` but not both");
        if (!csvSource.textBlock().isEmpty()) {
            return csvSource.textBlock();
        }
        for (int i = 0; i < values.length; ++i) {
            int finalI = i;
            Preconditions.notBlank((String)values[i], () -> "CSV record at index %d must not be blank".formatted(finalI + 1));
        }
        return String.join((CharSequence)"\n", values);
    }

    static Arguments processCsvRecord(CsvRecord record, boolean useHeadersInDisplayName) {
        List<String> fields = record.getFields();
        List<Object> headers = useHeadersInDisplayName ? CsvArgumentsProvider.getHeaders(record) : List.of();
        Preconditions.condition((!useHeadersInDisplayName || fields.size() <= headers.size() ? 1 : 0) != 0, () -> String.format("The number of columns (%d) exceeds the number of supplied headers (%d) in CSV record: %s", fields.size(), headers.size(), fields));
        @Nullable Object[] arguments = new Object[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            Named<Object> argument = CsvArgumentsProvider.resolveNullMarker(fields.get(i));
            if (useHeadersInDisplayName) {
                String header = CsvArgumentsProvider.resolveNullMarker((String)headers.get(i));
                argument = CsvArgumentsProvider.asNamed(header + " = " + String.valueOf(argument), argument);
            }
            arguments[i] = argument;
        }
        return Arguments.of(arguments);
    }

    private static List<String> getHeaders(CsvRecord record) {
        return ((NamedCsvRecord)record).getHeader();
    }

    private static @Nullable String resolveNullMarker(String record) {
        return record == CsvReaderFactory.DefaultFieldModifier.NULL_MARKER ? null : record;
    }

    private static Named<@Nullable Object> asNamed(String name, @Nullable Object column) {
        return Named.of((String)name, (Object)column);
    }

    static RuntimeException handleCsvException(Throwable throwable, Annotation annotation) {
        UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)throwable);
        if (throwable instanceof PreconditionViolationException) {
            PreconditionViolationException exception = (PreconditionViolationException)throwable;
            throw exception;
        }
        throw new CsvParsingException("Failed to parse CSV input configured via " + String.valueOf(annotation), throwable);
    }
}

