/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CommentStrategy;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvCallbackHandler;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvParseException;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvParser;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.util.Nullable;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.util.Preconditions;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.util.Util;

final class StrictCsvParser
implements CsvParser {
    private static final int STATUS_LAST_CHAR_WAS_CR = 32;
    private static final int STATUS_COMMENTED_RECORD = 16;
    private static final int STATUS_NEW_FIELD = 8;
    private static final int STATUS_QUOTED_MODE = 4;
    private static final int STATUS_QUOTED_FIELD = 2;
    private static final int STATUS_DATA_FIELD = 1;
    private static final int STATUS_RESET = 0;
    private final char fsep;
    private final char qChar;
    private final CommentStrategy cStrat;
    private final char cChar;
    private final boolean allowExtraCharsAfterClosingQuote;
    private final CsvCallbackHandler<?> callbackHandler;
    private final CsvBuffer csvBuffer;
    private long startingLineNumber;
    private int lines = 1;
    private boolean firstField;
    private int status;
    private boolean finished;

    StrictCsvParser(char fieldSeparator, char quoteCharacter, CommentStrategy commentStrategy, char commentCharacter, boolean allowExtraCharsAfterClosingQuote, CsvCallbackHandler<?> callbackHandler, int maxBufferSize, Reader reader) {
        this.assertFields(fieldSeparator, quoteCharacter, commentCharacter);
        this.fsep = fieldSeparator;
        this.qChar = quoteCharacter;
        this.cStrat = commentStrategy;
        this.cChar = commentCharacter;
        this.allowExtraCharsAfterClosingQuote = allowExtraCharsAfterClosingQuote;
        this.callbackHandler = callbackHandler;
        this.csvBuffer = new CsvBuffer(reader, maxBufferSize);
    }

    StrictCsvParser(char fieldSeparator, char quoteCharacter, CommentStrategy commentStrategy, char commentCharacter, boolean allowExtraCharsAfterClosingQuote, CsvCallbackHandler<?> callbackHandler, String data) {
        this.assertFields(fieldSeparator, quoteCharacter, commentCharacter);
        this.fsep = fieldSeparator;
        this.qChar = quoteCharacter;
        this.cStrat = commentStrategy;
        this.cChar = commentCharacter;
        this.allowExtraCharsAfterClosingQuote = allowExtraCharsAfterClosingQuote;
        this.callbackHandler = callbackHandler;
        this.csvBuffer = new CsvBuffer(data);
    }

    private void assertFields(char fieldSeparator, char quoteCharacter, char commentCharacter) {
        Preconditions.checkArgument(!Util.isNewline(fieldSeparator), "fieldSeparator must not contain newline chars");
        Preconditions.checkArgument(!Util.isNewline(quoteCharacter), "quoteCharacter must not be a newline char");
        Preconditions.checkArgument(!Util.isNewline(commentCharacter), "commentCharacter must not be a newline char");
        Preconditions.checkArgument(!Util.containsDupe(fieldSeparator, quoteCharacter, commentCharacter), "Control characters must differ (fieldSeparator=%s, quoteCharacter=%s, commentCharacter=%s)".formatted(Character.valueOf(fieldSeparator), Character.valueOf(quoteCharacter), Character.valueOf(commentCharacter)));
    }

    @Override
    public boolean parse() throws IOException {
        if (this.finished) {
            return false;
        }
        this.startingLineNumber += (long)this.lines;
        this.lines = 1;
        this.callbackHandler.beginRecord(this.startingLineNumber);
        this.firstField = true;
        do {
            if (this.csvBuffer.len != this.csvBuffer.pos || this.csvBuffer.fetchData()) continue;
            this.finished = true;
            return this.processBufferTail();
        } while (this.consume(this.csvBuffer.buf, this.csvBuffer.len));
        return true;
    }

    private boolean processBufferTail() {
        if (this.csvBuffer.begin < this.csvBuffer.pos) {
            this.materialize(this.csvBuffer.buf, this.csvBuffer.begin, this.csvBuffer.pos, this.status, this.qChar);
            return true;
        }
        if ((this.status & 8) != 0 || (this.status & 0x10) != 0) {
            this.materialize(this.csvBuffer.buf, 0, 0, this.status, this.qChar);
            return true;
        }
        return false;
    }

    boolean consume(char[] lBuf, int lLen) {
        boolean moreDataNeeded;
        int lBegin;
        int lPos;
        block25: {
            lPos = this.csvBuffer.pos;
            lBegin = this.csvBuffer.begin;
            int lStatus = this.status;
            moreDataNeeded = true;
            block0: do {
                char lookAhead;
                char c;
                if ((lStatus & 4) != 0) {
                    while (lPos < lLen) {
                        if ((c = lBuf[lPos++]) == this.qChar) {
                            lStatus &= 0xFFFFFFFB;
                            continue block0;
                        }
                        if (c == '\r') {
                            lStatus |= 0x20;
                            ++this.lines;
                            continue;
                        }
                        if (c == '\n') {
                            if ((lStatus & 0x20) == 0) {
                                ++this.lines;
                                continue;
                            }
                            lStatus &= 0xFFFFFFDF;
                            continue;
                        }
                        while (lPos < lLen && (lookAhead = lBuf[lPos]) != this.qChar && lookAhead != '\n' && lookAhead != '\r') {
                            ++lPos;
                        }
                    }
                    continue;
                }
                if ((lStatus & 0x10) != 0) {
                    while (lPos < lLen) {
                        char lookAhead2;
                        if ((lookAhead2 = lBuf[lPos++]) == '\r') {
                            this.materialize(lBuf, lBegin, lPos - 1, lStatus, this.qChar);
                            this.status = 32;
                            lBegin = lPos;
                            moreDataNeeded = false;
                        } else {
                            if (lookAhead2 != '\n') continue;
                            this.materialize(lBuf, lBegin, lPos - 1, lStatus, this.qChar);
                            this.status = 0;
                            lBegin = lPos;
                            moreDataNeeded = false;
                        }
                        break block25;
                    }
                    continue;
                }
                while (lPos < lLen) {
                    if ((c = lBuf[lPos++]) == this.fsep) {
                        this.materialize(lBuf, lBegin, lPos - 1, lStatus, this.qChar);
                        lStatus = 8;
                        lBegin = lPos;
                        this.firstField = false;
                        continue;
                    }
                    if (c == '\r') {
                        if (this.firstField && lPos - 1 == lBegin) {
                            this.callbackHandler.setEmpty();
                        } else {
                            this.materialize(lBuf, lBegin, lPos - 1, lStatus, this.qChar);
                        }
                        this.status = 32;
                        lBegin = lPos;
                        moreDataNeeded = false;
                        break block25;
                    }
                    if (c == '\n') {
                        if ((lStatus & 0x20) == 0) {
                            if (this.firstField && lPos - 1 == lBegin) {
                                this.callbackHandler.setEmpty();
                            } else {
                                this.materialize(lBuf, lBegin, lPos - 1, lStatus, this.qChar);
                            }
                            this.status = 0;
                            lBegin = lPos;
                            moreDataNeeded = false;
                            break block25;
                        }
                        lStatus = 0;
                        lBegin = lPos;
                        continue;
                    }
                    if (this.cStrat != CommentStrategy.NONE && c == this.cChar && (lStatus == 0 || lStatus == 32)) {
                        lBegin = lPos;
                        lStatus = 16;
                        continue block0;
                    }
                    if (c == this.qChar && (lStatus & 1) == 0) {
                        lStatus = 6;
                        continue block0;
                    }
                    if ((lStatus & 2) == 0) {
                        lStatus = 1;
                        while (lPos < lLen && (lookAhead = lBuf[lPos]) != this.fsep && lookAhead != '\n' && lookAhead != '\r') {
                            ++lPos;
                        }
                        continue;
                    }
                    if (this.allowExtraCharsAfterClosingQuote) continue;
                    throw new CsvParseException("Unexpected character after closing quote: '%c' (0x%x)".formatted(Character.valueOf(c), c));
                }
            } while (lPos < lLen);
            this.status = lStatus;
        }
        this.csvBuffer.pos = lPos;
        this.csvBuffer.begin = lBegin;
        return moreDataNeeded;
    }

    private void materialize(char[] lBuf, int lBegin, int lPos, int lStatus, char quoteCharacter) {
        if ((lStatus & 2) != 0) {
            int beginAfterQuote = lBegin + 1;
            int endAfterField = lPos - (lBuf[lPos - 1] == quoteCharacter ? 1 : 0);
            this.callbackHandler.addField(lBuf, beginAfterQuote, StrictCsvParser.cleanDelimiters(lBuf, beginAfterQuote, endAfterField, quoteCharacter), true);
            return;
        }
        if ((lStatus & 0x10) != 0) {
            this.callbackHandler.setComment(lBuf, lBegin, lPos - lBegin);
            return;
        }
        this.callbackHandler.addField(lBuf, lBegin, lPos - lBegin, false);
    }

    private static int cleanDelimiters(char[] buf, int begin, int end, char quoteCharacter) {
        int i;
        for (i = begin; i < end && buf[i] != quoteCharacter; ++i) {
        }
        int newPos = i;
        boolean escape = false;
        while (i < end) {
            block5: {
                char c;
                block4: {
                    c = buf[i];
                    if (c != quoteCharacter) break block4;
                    boolean bl = escape = !escape;
                    if (escape) break block5;
                }
                buf[newPos++] = c;
            }
            ++i;
        }
        return newPos - begin;
    }

    @Override
    public long getStartingLineNumber() {
        return this.startingLineNumber;
    }

    @Override
    public void reset(long startingLineNumber) {
        this.startingLineNumber = startingLineNumber;
        this.csvBuffer.reset();
    }

    @Override
    public void close() throws IOException {
        this.csvBuffer.close();
    }

    @Override
    public String peekLine() throws IOException {
        char c;
        if (this.csvBuffer.pos == this.csvBuffer.len && !this.csvBuffer.fetchData()) {
            throw new EOFException();
        }
        int savedPos = this.csvBuffer.pos;
        while ((this.csvBuffer.pos < this.csvBuffer.len || this.csvBuffer.fetchData()) && (c = this.csvBuffer.buf[this.csvBuffer.pos]) != '\r' && c != '\n') {
            ++this.csvBuffer.pos;
        }
        String s = new String(this.csvBuffer.buf, this.csvBuffer.begin, this.csvBuffer.pos - this.csvBuffer.begin);
        this.csvBuffer.pos = savedPos;
        return s;
    }

    @Override
    public void skipLine(int numCharsToSkip) throws IOException {
        char c;
        this.csvBuffer.pos += numCharsToSkip;
        if (this.csvBuffer.pos >= this.csvBuffer.len && !this.csvBuffer.fetchData()) {
            if (numCharsToSkip == 0) {
                throw new EOFException();
            }
            return;
        }
        do {
            if ((c = this.csvBuffer.buf[this.csvBuffer.pos++]) != '\r') continue;
            if (this.csvBuffer.pos >= this.csvBuffer.len && !this.csvBuffer.fetchData() || this.csvBuffer.buf[this.csvBuffer.pos] != '\n') break;
            ++this.csvBuffer.pos;
            break;
        } while (c != '\n' && (this.csvBuffer.pos < this.csvBuffer.len || this.csvBuffer.fetchData()));
        if (this.csvBuffer.begin < this.csvBuffer.pos) {
            this.csvBuffer.begin = this.csvBuffer.pos;
            ++this.startingLineNumber;
        }
    }

    private static class CsvBuffer
    implements Closeable {
        private static final int DEFAULT_READ_SIZE = 8192;
        char[] buf;
        int len;
        int begin;
        int pos;
        @Nullable
        private final Reader reader;
        private final int maxBufferSize;
        private final int readSize;

        CsvBuffer(Reader reader, int maxBufferSize) {
            Preconditions.checkArgument(maxBufferSize > 0, "maxBufferSize must be > 0");
            this.reader = reader;
            this.maxBufferSize = maxBufferSize;
            this.readSize = Math.min(maxBufferSize, 8192);
            this.buf = new char[Math.min(maxBufferSize, this.readSize * 2)];
        }

        CsvBuffer(String data) {
            this.reader = null;
            this.maxBufferSize = -1;
            this.buf = data.toCharArray();
            this.len = data.length();
            this.readSize = -1;
        }

        private boolean fetchData() throws IOException {
            int cnt;
            if (this.reader == null) {
                return false;
            }
            if (this.buf.length - this.len < this.readSize) {
                if (this.begin == this.len) {
                    this.len = 0;
                    this.pos = 0;
                } else {
                    if (this.buf.length - this.len + this.begin < this.readSize) {
                        char[] newBuf = this.largerBuffer();
                        System.arraycopy(this.buf, this.begin, newBuf, 0, this.len - this.begin);
                        this.buf = newBuf;
                    } else {
                        System.arraycopy(this.buf, this.begin, this.buf, 0, this.len - this.begin);
                    }
                    this.pos -= this.begin;
                    this.len -= this.begin;
                }
                this.begin = 0;
            }
            if ((cnt = this.reader.read(this.buf, this.len, this.readSize)) == -1) {
                return false;
            }
            this.len += cnt;
            return true;
        }

        private char[] largerBuffer() {
            if (this.maxBufferSize == this.buf.length) {
                throw new CsvParseException("The maximum buffer size of %d is insufficient to read the data of a single field. This issue typically arises when a quotation begins but does not conclude within the confines of this buffer's maximum limit. ".formatted(this.maxBufferSize));
            }
            return new char[Math.min(this.maxBufferSize, this.buf.length * 2)];
        }

        private void reset() {
            this.len = 0;
            this.begin = 0;
            this.pos = 0;
        }

        @Override
        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }
    }
}

