/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.function.Try;
import org.junit.platform.commons.io.ResourceFilter;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.Resource;
import org.junit.platform.commons.support.ResourceSupport;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.MAINTAINED, since="1.0")
public final class ReflectionSupport {
    private ReflectionSupport() {
    }

    @API(status=API.Status.MAINTAINED, since="1.4")
    public static Try<Class<?>> tryToLoadClass(String name) {
        return ReflectionUtils.tryToLoadClass(name);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static Try<Class<?>> tryToLoadClass(String name, ClassLoader classLoader) {
        return ReflectionUtils.tryToLoadClass(name, classLoader);
    }

    @API(status=API.Status.DEPRECATED, since="1.14")
    @Deprecated(since="1.14", forRemoval=true)
    public static Try<Set<Resource>> tryToGetResources(String classpathResourceName) {
        return ResourceSupport.tryToGetResources(classpathResourceName).andThenTry(ReflectionSupport::toSupportResourcesSet);
    }

    @API(status=API.Status.DEPRECATED, since="1.14")
    @Deprecated(since="1.14", forRemoval=true)
    public static Try<Set<Resource>> tryToGetResources(String classpathResourceName, ClassLoader classLoader) {
        return ResourceSupport.tryToGetResources(classpathResourceName, classLoader).andThenTry(ReflectionSupport::toSupportResourcesSet);
    }

    public static List<Class<?>> findAllClassesInClasspathRoot(URI root, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.findAllClassesInClasspathRoot(root, classFilter, classNameFilter);
    }

    @API(status=API.Status.DEPRECATED, since="1.14")
    @Deprecated(since="1.14", forRemoval=true)
    public static List<Resource> findAllResourcesInClasspathRoot(URI root, Predicate<Resource> resourceFilter) {
        return ReflectionSupport.toSupportResourcesList(ResourceSupport.findAllResourcesInClasspathRoot(root, ReflectionSupport.toResourceFilter(resourceFilter)));
    }

    @API(status=API.Status.MAINTAINED, since="1.10")
    public static Stream<Class<?>> streamAllClassesInClasspathRoot(URI root, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.streamAllClassesInClasspathRoot(root, classFilter, classNameFilter);
    }

    @API(status=API.Status.DEPRECATED, since="1.14")
    @Deprecated(since="1.14", forRemoval=true)
    public static Stream<Resource> streamAllResourcesInClasspathRoot(URI root, Predicate<Resource> resourceFilter) {
        return ReflectionSupport.toSupportResourcesStream(ResourceSupport.streamAllResourcesInClasspathRoot(root, ReflectionSupport.toResourceFilter(resourceFilter)));
    }

    public static List<Class<?>> findAllClassesInPackage(String basePackageName, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.findAllClassesInPackage(basePackageName, classFilter, classNameFilter);
    }

    @API(status=API.Status.DEPRECATED, since="1.14")
    @Deprecated(since="1.14", forRemoval=true)
    public static List<Resource> findAllResourcesInPackage(String basePackageName, Predicate<Resource> resourceFilter) {
        return ReflectionSupport.toSupportResourcesList(ResourceSupport.findAllResourcesInPackage(basePackageName, ReflectionSupport.toResourceFilter(resourceFilter)));
    }

    @API(status=API.Status.MAINTAINED, since="1.10")
    public static Stream<Class<?>> streamAllClassesInPackage(String basePackageName, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.streamAllClassesInPackage(basePackageName, classFilter, classNameFilter);
    }

    @API(status=API.Status.DEPRECATED, since="1.14")
    @Deprecated(since="1.14", forRemoval=true)
    public static Stream<Resource> streamAllResourcesInPackage(String basePackageName, Predicate<Resource> resourceFilter) {
        return ReflectionSupport.toSupportResourcesStream(ResourceSupport.streamAllResourcesInPackage(basePackageName, ReflectionSupport.toResourceFilter(resourceFilter)));
    }

    @API(status=API.Status.MAINTAINED, since="1.1.1")
    public static List<Class<?>> findAllClassesInModule(String moduleName, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.findAllClassesInModule(moduleName, classFilter, classNameFilter);
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.1")
    public static List<Class<?>> findAllClassesInModule(Module module, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.findAllClassesInModule(module, classFilter, classNameFilter);
    }

    @API(status=API.Status.DEPRECATED, since="1.14")
    @Deprecated(since="1.14", forRemoval=true)
    public static List<Resource> findAllResourcesInModule(String moduleName, Predicate<Resource> resourceFilter) {
        return ReflectionSupport.toSupportResourcesList(ResourceSupport.findAllResourcesInModule(moduleName, ReflectionSupport.toResourceFilter(resourceFilter)));
    }

    @API(status=API.Status.MAINTAINED, since="1.10")
    public static Stream<Class<?>> streamAllClassesInModule(String moduleName, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.streamAllClassesInModule(moduleName, classFilter, classNameFilter);
    }

    @API(status=API.Status.DEPRECATED, since="1.14")
    @Deprecated(since="1.14", forRemoval=true)
    public static Stream<Resource> streamAllResourcesInModule(String moduleName, Predicate<Resource> resourceFilter) {
        return ReflectionSupport.toSupportResourcesStream(ResourceSupport.streamAllResourcesInModule(moduleName, ReflectionSupport.toResourceFilter(resourceFilter)));
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) {
        return ReflectionUtils.newInstance(clazz, args);
    }

    public static @Nullable Object invokeMethod(Method method, @Nullable Object target, Object ... args) {
        return ReflectionUtils.invokeMethod(method, target, args);
    }

    @API(status=API.Status.MAINTAINED, since="1.4")
    public static List<Field> findFields(Class<?> clazz, Predicate<Field> predicate, HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(traversalMode, "HierarchyTraversalMode must not be null");
        return ReflectionUtils.findFields(clazz, predicate, ReflectionUtils.HierarchyTraversalMode.valueOf(traversalMode.name()));
    }

    @API(status=API.Status.MAINTAINED, since="1.10")
    public static Stream<Field> streamFields(Class<?> clazz, Predicate<Field> predicate, HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(traversalMode, "HierarchyTraversalMode must not be null");
        return ReflectionUtils.streamFields(clazz, predicate, ReflectionUtils.HierarchyTraversalMode.valueOf(traversalMode.name()));
    }

    @API(status=API.Status.MAINTAINED, since="1.4")
    public static Try<@Nullable Object> tryToReadFieldValue(Field field, @Nullable Object instance) {
        return ReflectionUtils.tryToReadFieldValue(field, instance);
    }

    public static Optional<Method> findMethod(Class<?> clazz, String methodName, @Nullable String parameterTypeNames) {
        return ReflectionUtils.findMethod(clazz, methodName, parameterTypeNames);
    }

    public static Optional<Method> findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.findMethod(clazz, methodName, parameterTypes);
    }

    public static List<Method> findMethods(Class<?> clazz, Predicate<Method> predicate, HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(traversalMode, "HierarchyTraversalMode must not be null");
        return ReflectionUtils.findMethods(clazz, predicate, ReflectionUtils.HierarchyTraversalMode.valueOf(traversalMode.name()));
    }

    @API(status=API.Status.MAINTAINED, since="1.10")
    public static Stream<Method> streamMethods(Class<?> clazz, Predicate<Method> predicate, HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(traversalMode, "HierarchyTraversalMode must not be null");
        return ReflectionUtils.streamMethods(clazz, predicate, ReflectionUtils.HierarchyTraversalMode.valueOf(traversalMode.name()));
    }

    public static List<Class<?>> findNestedClasses(Class<?> clazz, Predicate<Class<?>> predicate) throws JUnitException {
        return ReflectionUtils.findNestedClasses(clazz, predicate);
    }

    @API(status=API.Status.MAINTAINED, since="1.10")
    public static Stream<Class<?>> streamNestedClasses(Class<?> clazz, Predicate<Class<?>> predicate) throws JUnitException {
        return ReflectionUtils.streamNestedClasses(clazz, predicate);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static Field makeAccessible(Field field) {
        return ReflectionUtils.makeAccessible(Preconditions.notNull(field, "field must not be null"));
    }

    private static ResourceFilter toResourceFilter(Predicate<Resource> resourceFilter) {
        Preconditions.notNull(resourceFilter, "resourceFilter must not be null");
        return ResourceFilter.of(r -> resourceFilter.test(Resource.of(r)));
    }

    static List<Resource> toSupportResourcesList(List<org.junit.platform.commons.io.Resource> resources) {
        return ReflectionSupport.toSupportResourcesStream(resources.stream()).toList();
    }

    static Set<Resource> toSupportResourcesSet(Set<org.junit.platform.commons.io.Resource> resources) {
        return ReflectionSupport.toSupportResourcesStream(resources.stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    static Stream<Resource> toSupportResourcesStream(Stream<org.junit.platform.commons.io.Resource> resources) {
        return resources.map(Resource::of);
    }
}

