/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support;

import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.platform.commons.function.Try;
import org.junit.platform.commons.io.Resource;
import org.junit.platform.commons.io.ResourceFilter;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.MAINTAINED, since="1.14")
public class ResourceSupport {
    public static Try<Set<Resource>> tryToGetResources(String classpathResourceName) {
        return ReflectionUtils.tryToGetResources(classpathResourceName);
    }

    public static Try<Set<Resource>> tryToGetResources(String classpathResourceName, ClassLoader classLoader) {
        return ReflectionUtils.tryToGetResources(classpathResourceName, classLoader);
    }

    public static List<Resource> findAllResourcesInClasspathRoot(URI root, ResourceFilter resourceFilter) {
        return ReflectionUtils.findAllResourcesInClasspathRoot(root, resourceFilter);
    }

    public static Stream<Resource> streamAllResourcesInClasspathRoot(URI root, ResourceFilter resourceFilter) {
        return ReflectionUtils.streamAllResourcesInClasspathRoot(root, resourceFilter);
    }

    public static List<Resource> findAllResourcesInPackage(String basePackageName, ResourceFilter resourceFilter) {
        return ReflectionUtils.findAllResourcesInPackage(basePackageName, resourceFilter);
    }

    public static Stream<Resource> streamAllResourcesInPackage(String basePackageName, ResourceFilter resourceFilter) {
        return ReflectionUtils.streamAllResourcesInPackage(basePackageName, resourceFilter);
    }

    public static List<Resource> findAllResourcesInModule(String moduleName, ResourceFilter resourceFilter) {
        return ReflectionUtils.findAllResourcesInModule(moduleName, resourceFilter);
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.1")
    public static List<Resource> findAllResourcesInModule(Module module, ResourceFilter resourceFilter) {
        return ReflectionUtils.findAllResourcesInModule(module, resourceFilter);
    }

    public static Stream<Resource> streamAllResourcesInModule(String moduleName, ResourceFilter resourceFilter) {
        return ReflectionUtils.streamAllResourcesInModule(moduleName, resourceFilter);
    }

    private ResourceSupport() {
    }
}

