/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.ext.spring.web;

import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.ext.spring.LogbackConfigurer;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.ServletContextPropertyUtils;
import org.springframework.web.util.WebUtils;

public class WebLogbackConfigurer {
    public static final String CONFIG_LOCATION_PARAM = "logbackConfigLocation";
    public static final String EXPOSE_WEB_APP_ROOT_PARAM = "logbackExposeWebAppRoot";

    private WebLogbackConfigurer() {
    }

    public static void initLogging(ServletContext servletContext) {
        String string;
        if (WebLogbackConfigurer.exposeWebAppRoot(servletContext)) {
            WebUtils.setWebAppRootSystemProperty((ServletContext)servletContext);
        }
        if ((string = servletContext.getInitParameter(CONFIG_LOCATION_PARAM)) != null) {
            for (String string2 : StringUtils.tokenizeToStringArray((String)string, (String)",; \t\n")) {
                try {
                    string2 = ServletContextPropertyUtils.resolvePlaceholders((String)string2, (ServletContext)servletContext);
                    if (!ResourceUtils.isUrl((String)string2)) {
                        string2 = WebUtils.getRealPath((ServletContext)servletContext, (String)string2);
                    }
                    servletContext.log("Initializing Logback from [" + string2 + "]");
                    LogbackConfigurer.initLogging(string2);
                    break;
                }
                catch (FileNotFoundException joranException) {
                    servletContext.log("No logback configuration file found at [" + string2 + "]");
                }
                catch (JoranException joranException) {
                    throw new RuntimeException("Unexpected error while configuring logback", joranException);
                }
            }
        }
        try {
            Method method;
            Class classNotFoundException = ClassUtils.forName((String)"org.slf4j.bridge.SLF4JBridgeHandler", (ClassLoader)ClassUtils.getDefaultClassLoader());
            Method method2 = ReflectionUtils.findMethod((Class)classNotFoundException, (String)"removeHandlersForRootLogger");
            if (method2 != null) {
                servletContext.log("Removing all previous handlers for JUL to SLF4J bridge");
                ReflectionUtils.invokeMethod((Method)method2, null);
            }
            if ((method = ReflectionUtils.findMethod((Class)classNotFoundException, (String)"install")) != null) {
                servletContext.log("Installing JUL to SLF4J bridge");
                ReflectionUtils.invokeMethod((Method)method, null);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            servletContext.log("JUL to SLF4J bridge is not available on the classpath");
        }
    }

    public static void shutdownLogging(ServletContext servletContext) {
        try {
            Class clazz = ClassUtils.forName((String)"org.slf4j.bridge.SLF4JBridgeHandler", (ClassLoader)ClassUtils.getDefaultClassLoader());
            Method method = ReflectionUtils.findMethod((Class)clazz, (String)"uninstall");
            if (method != null) {
                servletContext.log("Uninstalling JUL to SLF4J bridge");
                ReflectionUtils.invokeMethod((Method)method, null);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            servletContext.log("Shutting down Logback");
            LogbackConfigurer.shutdownLogging();
        }
        finally {
            if (WebLogbackConfigurer.exposeWebAppRoot(servletContext)) {
                WebUtils.removeWebAppRootSystemProperty((ServletContext)servletContext);
            }
        }
    }

    private static boolean exposeWebAppRoot(ServletContext servletContext) {
        String string = servletContext.getInitParameter(EXPOSE_WEB_APP_ROOT_PARAM);
        return string == null || Boolean.valueOf(string) != false;
    }
}

