/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.oauth.grant;

import java.util.LinkedHashMap;
import org.minbox.framework.oauth.grant.OAuth2TokenGranter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.AbstractTokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

public class DefaultApiBootOauthTokenGranter
extends AbstractTokenGranter {
    private OAuth2TokenGranter oAuth2TokenGranter;

    public DefaultApiBootOauthTokenGranter(AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService, OAuth2RequestFactory requestFactory, OAuth2TokenGranter OAuth2TokenGranter2) {
        super(tokenServices, clientDetailsService, requestFactory, OAuth2TokenGranter2.grantType());
        this.oAuth2TokenGranter = OAuth2TokenGranter2;
    }

    protected OAuth2Authentication getOAuth2Authentication(ClientDetails client, TokenRequest tokenRequest) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(tokenRequest.getRequestParameters());
        UserDetails userDetails = this.oAuth2TokenGranter.loadByParameter(parameters);
        UsernamePasswordAuthenticationToken userAuth = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
        ((AbstractAuthenticationToken)userAuth).setDetails(parameters);
        OAuth2Request storedOAuth2Request = this.getRequestFactory().createOAuth2Request(client, tokenRequest);
        return new OAuth2Authentication(storedOAuth2Request, (Authentication)userAuth);
    }
}

