/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.stream.Stream;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.proc.UserFunctionSignature;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Procedure;

public class BuiltInDbmsProcedures {
    @Context
    public GraphDatabaseAPI graph;

    @Description(value="List all procedures in the DBMS.")
    @Procedure(name="dbms.procedures", mode=Mode.DBMS)
    public Stream<ProcedureResult> listProcedures() {
        return ((Procedures)((Object)this.graph.getDependencyResolver().resolveDependency(Procedures.class))).getAllProcedures().stream().sorted((a, b) -> a.name().toString().compareTo(b.name().toString())).map(x$0 -> new ProcedureResult((ProcedureSignature)x$0));
    }

    @Description(value="List all user functions in the DBMS.")
    @Procedure(name="dbms.functions", mode=Mode.DBMS)
    public Stream<FunctionResult> listFunctions() {
        return ((Procedures)((Object)this.graph.getDependencyResolver().resolveDependency(Procedures.class))).getAllFunctions().stream().sorted((a, b) -> a.name().toString().compareTo(b.name().toString())).map(x$0 -> new FunctionResult((UserFunctionSignature)x$0));
    }

    public static class ProcedureResult {
        public final String name;
        public final String signature;
        public final String description;

        private ProcedureResult(ProcedureSignature signature) {
            this.name = signature.name().toString();
            this.signature = signature.toString();
            this.description = signature.description().orElse("");
        }
    }

    public static class FunctionResult {
        public final String name;
        public final String signature;
        public final String description;

        private FunctionResult(UserFunctionSignature signature) {
            this.name = signature.name().toString();
            this.signature = signature.toString();
            this.description = signature.description().orElse("");
        }
    }
}

