/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.DelegatingIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.updater.DelegatingIndexUpdater;

public class ContractCheckingIndexProxy
extends DelegatingIndexProxy {
    private final AtomicReference<State> state;
    private final AtomicInteger openCalls;

    public ContractCheckingIndexProxy(IndexProxy delegate, boolean started) {
        super(delegate);
        this.state = new AtomicReference<State>(started ? State.STARTED : State.INIT);
        this.openCalls = new AtomicInteger(0);
    }

    @Override
    public void start() throws IOException {
        if (this.state.compareAndSet(State.INIT, State.STARTING)) {
            try {
                super.start();
            }
            finally {
                this.state.set(State.STARTED);
            }
        } else {
            throw new IllegalStateException("An IndexProxy can only be started once");
        }
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        if (IndexUpdateMode.ONLINE == mode) {
            this.openCall("update");
            return new DelegatingIndexUpdater(super.newUpdater(mode)){

                @Override
                public void close() throws IOException, IndexEntryConflictException {
                    try {
                        this.delegate.close();
                    }
                    finally {
                        ContractCheckingIndexProxy.this.closeCall();
                    }
                }
            };
        }
        return super.newUpdater(mode);
    }

    @Override
    public void force() throws IOException {
        this.openCall("force");
        try {
            super.force();
        }
        finally {
            this.closeCall();
        }
    }

    @Override
    public Future<Void> drop() throws IOException {
        if (this.state.compareAndSet(State.INIT, State.CLOSED)) {
            return super.drop();
        }
        if (State.STARTING.equals((Object)this.state.get())) {
            throw new IllegalStateException("Concurrent drop while creating index");
        }
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            this.ensureNoOpenCalls("drop");
            return super.drop();
        }
        throw new IllegalStateException("IndexProxy already closed");
    }

    @Override
    public Future<Void> close() throws IOException {
        if (this.state.compareAndSet(State.INIT, State.CLOSED)) {
            return super.close();
        }
        if (this.state.compareAndSet(State.STARTING, State.CLOSED)) {
            throw new IllegalStateException("Concurrent close while creating index");
        }
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            this.ensureNoOpenCalls("close");
            return super.close();
        }
        throw new IllegalStateException("IndexProxy already closed");
    }

    private void openCall(String name) {
        if (State.STARTED.equals((Object)this.state.get())) {
            this.openCalls.incrementAndGet();
            if (State.CLOSED.equals((Object)this.state.get())) {
                throw new IllegalStateException("Cannot call " + name + "() after index has been closed");
            }
        } else {
            throw new IllegalStateException("Cannot call " + name + "() before index has been started");
        }
    }

    private void ensureNoOpenCalls(String name) {
        if (this.openCalls.get() > 0) {
            throw new IllegalStateException("Concurrent " + name + "() while updates have not completed");
        }
    }

    private void closeCall() {
        this.openCalls.decrementAndGet();
    }

    private static enum State {
        INIT,
        STARTING,
        STARTED,
        CLOSED;

    }
}

