/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.PositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.PositionableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.storageengine.api.ReadPastEndException;

public class InMemoryClosableChannel
implements ReadableClosablePositionAwareChannel,
FlushablePositionAwareChannel {
    private final byte[] bytes;
    private final Reader reader;
    private final Writer writer;
    private static final Flushable NO_OP_FLUSHABLE = () -> {};

    public InMemoryClosableChannel() {
        this(1000);
    }

    public InMemoryClosableChannel(byte[] bytes, boolean append) {
        this.bytes = bytes;
        ByteBuffer writeBuffer = ByteBuffer.wrap(this.bytes);
        ByteBuffer readBuffer = ByteBuffer.wrap(this.bytes);
        if (append) {
            writeBuffer.position(bytes.length);
        }
        this.writer = new Writer(writeBuffer);
        this.reader = new Reader(readBuffer);
    }

    public InMemoryClosableChannel(int bufferSize) {
        this(new byte[bufferSize], false);
    }

    public void reset() {
        this.writer.clear();
        this.reader.clear();
        Arrays.fill(this.bytes, (byte)0);
    }

    public Reader reader() {
        return this.reader;
    }

    public Writer writer() {
        return this.writer;
    }

    @Override
    public InMemoryClosableChannel put(byte b) throws IOException {
        this.writer.put(b);
        return this;
    }

    @Override
    public InMemoryClosableChannel putShort(short s) throws IOException {
        this.writer.putShort(s);
        return this;
    }

    @Override
    public InMemoryClosableChannel putInt(int i) throws IOException {
        this.writer.putInt(i);
        return this;
    }

    @Override
    public InMemoryClosableChannel putLong(long l) throws IOException {
        this.writer.putLong(l);
        return this;
    }

    @Override
    public InMemoryClosableChannel putFloat(float f) throws IOException {
        this.writer.putFloat(f);
        return this;
    }

    @Override
    public InMemoryClosableChannel putDouble(double d) throws IOException {
        this.writer.putDouble(d);
        return this;
    }

    @Override
    public InMemoryClosableChannel put(byte[] bytes, int length) throws IOException {
        this.writer.put(bytes, length);
        return this;
    }

    public StoreChannel getFileChannel() {
        throw new UnsupportedOperationException();
    }

    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.writer.close();
    }

    @Override
    public Flushable prepareForFlush() {
        return NO_OP_FLUSHABLE;
    }

    @Override
    public byte get() throws ReadPastEndException {
        return this.reader.get();
    }

    @Override
    public short getShort() throws ReadPastEndException {
        return this.reader.getShort();
    }

    @Override
    public int getInt() throws ReadPastEndException {
        return this.reader.getInt();
    }

    @Override
    public long getLong() throws ReadPastEndException {
        return this.reader.getLong();
    }

    @Override
    public float getFloat() throws ReadPastEndException {
        return this.reader.getFloat();
    }

    @Override
    public double getDouble() throws ReadPastEndException {
        return this.reader.getDouble();
    }

    @Override
    public void get(byte[] bytes, int length) throws ReadPastEndException {
        this.reader.get(bytes, length);
    }

    @Override
    public LogPositionMarker getCurrentPosition(LogPositionMarker positionMarker) throws IOException {
        return this.writer.getCurrentPosition(positionMarker);
    }

    public int positionWriter(int position) {
        int previous = this.writer.position();
        this.writer.position(position);
        return previous;
    }

    public int positionReader(int position) {
        int previous = this.reader.position();
        this.reader.position(position);
        return previous;
    }

    public int readerPosition() {
        return this.reader.position();
    }

    public int writerPosition() {
        return this.writer.position();
    }

    public void truncateTo(int offset) {
        this.reader.limit(offset);
    }

    public int capacity() {
        return this.bytes.length;
    }

    public int availableBytesToRead() {
        return this.reader.remaining();
    }

    public int availableBytesToWrite() {
        return this.writer.remaining();
    }

    public class Writer
    extends ByteBufferBase
    implements FlushablePositionAwareChannel {
        Writer(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public Writer put(byte b) throws IOException {
            this.buffer.put(b);
            return this;
        }

        @Override
        public Writer putShort(short s) throws IOException {
            this.buffer.putShort(s);
            return this;
        }

        @Override
        public Writer putInt(int i) throws IOException {
            this.buffer.putInt(i);
            return this;
        }

        @Override
        public Writer putLong(long l) throws IOException {
            this.buffer.putLong(l);
            return this;
        }

        @Override
        public Writer putFloat(float f) throws IOException {
            this.buffer.putFloat(f);
            return this;
        }

        @Override
        public Writer putDouble(double d) throws IOException {
            this.buffer.putDouble(d);
            return this;
        }

        @Override
        public Writer put(byte[] bytes, int length) throws IOException {
            this.buffer.put(bytes, 0, length);
            return this;
        }

        @Override
        public Flushable prepareForFlush() throws IOException {
            return NO_OP_FLUSHABLE;
        }
    }

    public class Reader
    extends ByteBufferBase
    implements ReadableClosablePositionAwareChannel,
    PositionableChannel {
        Reader(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public byte get() throws ReadPastEndException {
            this.ensureAvailableToRead(1);
            return this.buffer.get();
        }

        @Override
        public short getShort() throws ReadPastEndException {
            this.ensureAvailableToRead(2);
            return this.buffer.getShort();
        }

        @Override
        public int getInt() throws ReadPastEndException {
            this.ensureAvailableToRead(4);
            return this.buffer.getInt();
        }

        @Override
        public long getLong() throws ReadPastEndException {
            this.ensureAvailableToRead(8);
            return this.buffer.getLong();
        }

        @Override
        public float getFloat() throws ReadPastEndException {
            this.ensureAvailableToRead(4);
            return this.buffer.getFloat();
        }

        @Override
        public double getDouble() throws ReadPastEndException {
            this.ensureAvailableToRead(8);
            return this.buffer.getDouble();
        }

        @Override
        public void get(byte[] bytes, int length) throws ReadPastEndException {
            this.ensureAvailableToRead(length);
            this.buffer.get(bytes, 0, length);
        }

        private void ensureAvailableToRead(int i) throws ReadPastEndException {
            if (this.remaining() < i || this.position() + i > InMemoryClosableChannel.this.writer.position()) {
                throw ReadPastEndException.INSTANCE;
            }
        }

        @Override
        public void setCurrentPosition(long byteOffset) throws IOException {
            this.buffer.position(Math.toIntExact(byteOffset));
        }
    }

    class ByteBufferBase
    implements PositionAwareChannel,
    Closeable {
        protected final ByteBuffer buffer;

        ByteBufferBase(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        void clear() {
            this.buffer.clear();
        }

        int position() {
            return this.buffer.position();
        }

        void position(int position) {
            this.buffer.position(position);
        }

        int remaining() {
            return this.buffer.remaining();
        }

        void limit(int offset) {
            this.buffer.limit(offset);
        }

        @Override
        public void close() {
        }

        @Override
        public LogPositionMarker getCurrentPosition(LogPositionMarker positionMarker) throws IOException {
            positionMarker.mark(0L, this.buffer.position());
            return positionMarker;
        }
    }
}

