/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.executor;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.neo4j.function.Suppliers;
import org.neo4j.helpers.Exceptions;
import org.neo4j.unsafe.impl.batchimport.executor.ParkStrategy;
import org.neo4j.unsafe.impl.batchimport.executor.Task;
import org.neo4j.unsafe.impl.batchimport.executor.TaskExecutionPanicException;
import org.neo4j.unsafe.impl.batchimport.executor.TaskExecutor;

public class DynamicTaskExecutor<LOCAL>
implements TaskExecutor<LOCAL> {
    public static final ParkStrategy DEFAULT_PARK_STRATEGY = new ParkStrategy.Park(10L, TimeUnit.MILLISECONDS);
    private final BlockingQueue<Task<LOCAL>> queue;
    private final ParkStrategy parkStrategy;
    private final String processorThreadNamePrefix;
    private volatile Processor[] processors = (Processor[])Array.newInstance(Processor.class, 0);
    private volatile boolean shutDown;
    private volatile Throwable panic;
    private final Supplier<LOCAL> initialLocalState;
    private final int maxProcessorCount;
    private static final Thread.UncaughtExceptionHandler SILENT_UNCAUGHT_EXCEPTION_HANDLER = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
        }
    };

    public DynamicTaskExecutor(int initialProcessorCount, int maxProcessorCount, int maxQueueSize, ParkStrategy parkStrategy, String processorThreadNamePrefix) {
        this(initialProcessorCount, maxProcessorCount, maxQueueSize, parkStrategy, processorThreadNamePrefix, Suppliers.singleton(null));
    }

    public DynamicTaskExecutor(int initialProcessorCount, int maxProcessorCount, int maxQueueSize, ParkStrategy parkStrategy, String processorThreadNamePrefix, Supplier<LOCAL> initialLocalState) {
        int n = this.maxProcessorCount = maxProcessorCount == 0 ? Integer.MAX_VALUE : maxProcessorCount;
        assert (this.maxProcessorCount >= initialProcessorCount) : "Unexpected initial processor count " + initialProcessorCount + " for max " + maxProcessorCount;
        this.parkStrategy = parkStrategy;
        this.processorThreadNamePrefix = processorThreadNamePrefix;
        this.initialLocalState = initialLocalState;
        this.queue = new ArrayBlockingQueue<Task<LOCAL>>(maxQueueSize);
        this.processors(initialProcessorCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processors(int delta) {
        if (this.shutDown || delta == 0) {
            return this.processors.length;
        }
        DynamicTaskExecutor dynamicTaskExecutor = this;
        synchronized (dynamicTaskExecutor) {
            if (this.shutDown) {
                return this.processors.length;
            }
            int requestedNumber = this.processors.length + delta;
            if (delta > 0) {
                if ((requestedNumber = Integer.min(requestedNumber, this.maxProcessorCount)) > this.processors.length) {
                    Processor[] newProcessors = Arrays.copyOf(this.processors, requestedNumber);
                    for (int i = this.processors.length; i < requestedNumber; ++i) {
                        newProcessors[i] = new Processor(this.processorThreadNamePrefix + "-" + i);
                    }
                    this.processors = newProcessors;
                }
            } else if ((requestedNumber = Integer.max(1, requestedNumber)) < this.processors.length) {
                Processor[] newProcessors = Arrays.copyOf(this.processors, requestedNumber);
                for (int i = newProcessors.length; i < this.processors.length; ++i) {
                    this.processors[i].processorShutDown = true;
                }
                this.processors = newProcessors;
            }
            return this.processors.length;
        }
    }

    @Override
    public void submit(Task<LOCAL> task) {
        this.assertHealthy();
        try {
            while (!this.queue.offer(task, 10L, TimeUnit.MILLISECONDS)) {
                this.assertHealthy();
            }
            this.notifyProcessors();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void assertHealthy() {
        if (this.shutDown && this.panic != null) {
            throw new TaskExecutionPanicException("Executor has been shut down in panic", this.panic);
        }
    }

    private void notifyProcessors() {
        for (Processor processor : this.processors) {
            this.parkStrategy.unpark(processor);
        }
    }

    @Override
    public void receivePanic(Throwable cause) {
        this.panic = cause;
    }

    @Override
    public synchronized void close() {
        if (this.shutDown) {
            return;
        }
        while (!this.queue.isEmpty() && this.panic == null) {
            this.parkAWhile();
        }
        this.shutDown = true;
        while (this.anyAlive() && this.panic == null) {
            this.parkAWhile();
        }
    }

    @Override
    public boolean isClosed() {
        return this.shutDown;
    }

    private boolean anyAlive() {
        for (Processor processor : this.processors) {
            if (!processor.isAlive()) continue;
            return true;
        }
        return false;
    }

    private void parkAWhile() {
        this.parkStrategy.park(Thread.currentThread());
    }

    private class Processor
    extends Thread {
        private volatile boolean processorShutDown;

        Processor(String name) {
            super(name);
            this.setUncaughtExceptionHandler(SILENT_UNCAUGHT_EXCEPTION_HANDLER);
            this.start();
        }

        @Override
        public void run() {
            Object threadLocalState = DynamicTaskExecutor.this.initialLocalState.get();
            while (!DynamicTaskExecutor.this.shutDown && !this.processorShutDown) {
                Task task = (Task)DynamicTaskExecutor.this.queue.poll();
                if (task != null) {
                    try {
                        task.run(threadLocalState);
                        continue;
                    }
                    catch (Throwable e) {
                        DynamicTaskExecutor.this.receivePanic(e);
                        DynamicTaskExecutor.this.close();
                        throw Exceptions.launderedException(e);
                    }
                }
                if (this.processorShutDown) break;
                DynamicTaskExecutor.this.parkAWhile();
            }
        }
    }
}

