/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.neo4j.function.Suppliers;
import org.neo4j.logging.AbstractLog;
import org.neo4j.logging.AbstractPrintWriterLogger;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;
import org.neo4j.logging.NullLogger;

public class FormattedLog
extends AbstractLog {
    static final Supplier<Date> DEFAULT_CURRENT_DATE_SUPPLIER = Date::new;
    static final Function<OutputStream, PrintWriter> OUTPUT_STREAM_CONVERTER = outputStream -> new PrintWriter(new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8));
    static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final Supplier<Date> currentDateSupplier;
    private final Supplier<PrintWriter> writerSupplier;
    private final TimeZone timezone;
    private final Object lock;
    private final String category;
    private final AtomicReference<Level> levelRef;
    private final boolean autoFlush;
    private final Logger debugLogger;
    private final Logger infoLogger;
    private final Logger warnLogger;
    private final Logger errorLogger;

    public static Builder withUTCTimeZone() {
        return new Builder().withUTCTimeZone();
    }

    public static Builder withTimeZone(TimeZone timezone) {
        return new Builder().withTimeZone(timezone);
    }

    public static Builder usingLock(Object lock) {
        return new Builder().usingLock(lock);
    }

    public static Builder withCategory(String category) {
        return new Builder().withCategory(category);
    }

    public static Builder withLogLevel(Level level) {
        return new Builder().withLogLevel(level);
    }

    public static Builder withoutAutoFlush() {
        return new Builder().withoutAutoFlush();
    }

    public static FormattedLog toOutputStream(OutputStream out) {
        return new Builder().toOutputStream(out);
    }

    public static FormattedLog toOutputStream(Supplier<OutputStream> outSupplier) {
        return new Builder().toOutputStream(outSupplier);
    }

    public static FormattedLog toWriter(Writer writer) {
        return new Builder().toWriter(writer);
    }

    public static FormattedLog toPrintWriter(PrintWriter writer) {
        return new Builder().toPrintWriter(writer);
    }

    public static FormattedLog toPrintWriter(Supplier<PrintWriter> writerSupplier) {
        return new Builder().toPrintWriter(writerSupplier);
    }

    protected FormattedLog(Supplier<Date> currentDateSupplier, Supplier<PrintWriter> writerSupplier, TimeZone timezone, Object maybeLock, String category, Level level, boolean autoFlush) {
        this.currentDateSupplier = currentDateSupplier;
        this.writerSupplier = writerSupplier;
        this.timezone = timezone;
        this.lock = maybeLock != null ? maybeLock : this;
        this.category = category;
        this.levelRef = new AtomicReference<Level>(level);
        this.autoFlush = autoFlush;
        String debugPrefix = category != null && !category.isEmpty() ? "DEBUG [" + category + "]" : "DEBUG";
        String infoPrefix = category != null && !category.isEmpty() ? "INFO [" + category + "]" : "INFO ";
        String warnPrefix = category != null && !category.isEmpty() ? "WARN [" + category + "]" : "WARN ";
        String errorPrefix = category != null && !category.isEmpty() ? "ERROR [" + category + "]" : "ERROR";
        this.debugLogger = new FormattedLogger(writerSupplier, debugPrefix);
        this.infoLogger = new FormattedLogger(writerSupplier, infoPrefix);
        this.warnLogger = new FormattedLogger(writerSupplier, warnPrefix);
        this.errorLogger = new FormattedLogger(writerSupplier, errorPrefix);
    }

    public Level getLevel() {
        return this.levelRef.get();
    }

    public Level setLevel(Level level) {
        return this.levelRef.getAndSet(level);
    }

    @Override
    public boolean isDebugEnabled() {
        return Level.DEBUG.compareTo((Enum)this.levelRef.get()) >= 0;
    }

    @Override
    @Nonnull
    public Logger debugLogger() {
        return this.isDebugEnabled() ? this.debugLogger : NullLogger.getInstance();
    }

    public boolean isInfoEnabled() {
        return Level.INFO.compareTo((Enum)this.levelRef.get()) >= 0;
    }

    @Override
    @Nonnull
    public Logger infoLogger() {
        return this.isInfoEnabled() ? this.infoLogger : NullLogger.getInstance();
    }

    public boolean isWarnEnabled() {
        return Level.WARN.compareTo((Enum)this.levelRef.get()) >= 0;
    }

    @Override
    @Nonnull
    public Logger warnLogger() {
        return this.isWarnEnabled() ? this.warnLogger : NullLogger.getInstance();
    }

    public boolean isErrorEnabled() {
        return Level.ERROR.compareTo((Enum)this.levelRef.get()) >= 0;
    }

    @Override
    @Nonnull
    public Logger errorLogger() {
        return this.isErrorEnabled() ? this.errorLogger : NullLogger.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bulk(@Nonnull Consumer<Log> consumer) {
        PrintWriter writer;
        Object object = this.lock;
        synchronized (object) {
            writer = this.writerSupplier.get();
            consumer.accept(new FormattedLog(this.currentDateSupplier, Suppliers.singleton((Object)writer), this.timezone, this.lock, this.category, this.levelRef.get(), false));
        }
        if (this.autoFlush) {
            writer.flush();
        }
    }

    private class FormattedLogger
    extends AbstractPrintWriterLogger {
        private final String prefix;
        private final DateFormat format;

        FormattedLogger(@Nonnull Supplier<PrintWriter> writerSupplier, String prefix) {
            super(writerSupplier, FormattedLog.this.lock, FormattedLog.this.autoFlush);
            this.prefix = prefix;
            this.format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
            this.format.setTimeZone(FormattedLog.this.timezone);
        }

        @Override
        protected void writeLog(@Nonnull PrintWriter out, @Nonnull String message) {
            this.lineStart(out);
            out.write(message);
            out.println();
        }

        @Override
        protected void writeLog(@Nonnull PrintWriter out, @Nonnull String message, @Nonnull Throwable throwable) {
            this.lineStart(out);
            out.write(message);
            if (throwable.getMessage() != null) {
                out.write(32);
                out.write(throwable.getMessage());
            }
            out.println();
            throwable.printStackTrace(out);
        }

        @Override
        protected Logger getBulkLogger(@Nonnull PrintWriter out, @Nonnull Object lock) {
            return new FormattedLogger(Suppliers.singleton((Object)out), this.prefix);
        }

        private void lineStart(PrintWriter out) {
            out.write(this.time());
            out.write(32);
            out.write(this.prefix);
            out.write(32);
        }

        private String time() {
            return this.format.format((Date)FormattedLog.this.currentDateSupplier.get());
        }
    }

    public static class Builder {
        private TimeZone timezone = UTC;
        private Object lock = this;
        private String category = null;
        private Level level = Level.INFO;
        private boolean autoFlush = true;

        private Builder() {
        }

        public Builder withUTCTimeZone() {
            return this.withTimeZone(UTC);
        }

        public Builder withTimeZone(TimeZone timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder usingLock(Object lock) {
            this.lock = lock;
            return this;
        }

        public Builder withCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder withLogLevel(Level level) {
            this.level = level;
            return this;
        }

        public Builder withoutAutoFlush() {
            this.autoFlush = false;
            return this;
        }

        public FormattedLog toOutputStream(OutputStream out) {
            return this.toPrintWriter(Suppliers.singleton((Object)OUTPUT_STREAM_CONVERTER.apply(out)));
        }

        public FormattedLog toOutputStream(Supplier<OutputStream> outSupplier) {
            return this.toPrintWriter(Suppliers.adapted(outSupplier, OUTPUT_STREAM_CONVERTER));
        }

        public FormattedLog toWriter(Writer writer) {
            return this.toPrintWriter(new PrintWriter(writer));
        }

        public FormattedLog toPrintWriter(PrintWriter writer) {
            return this.toPrintWriter(Suppliers.singleton((Object)writer));
        }

        public FormattedLog toPrintWriter(Supplier<PrintWriter> writerSupplier) {
            return new FormattedLog(DEFAULT_CURRENT_DATE_SUPPLIER, writerSupplier, this.timezone, this.lock, this.category, this.level, this.autoFlush);
        }
    }
}

