/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.neo4j.index.impl.lucene.legacy.IndexIdentifier;
import org.neo4j.index.impl.lucene.legacy.IndexReference;
import org.neo4j.index.impl.lucene.legacy.IndexType;
import org.neo4j.index.impl.lucene.legacy.IndexTypeCache;
import org.neo4j.index.impl.lucene.legacy.LuceneDataSource;
import org.neo4j.kernel.api.exceptions.legacyindex.LegacyIndexNotFoundKernelException;

abstract class IndexReferenceFactory {
    private final File baseStorePath;
    private final IndexTypeCache typeCache;
    private final LuceneDataSource.LuceneFilesystemFacade filesystemFacade;

    IndexReferenceFactory(LuceneDataSource.LuceneFilesystemFacade filesystemFacade, File baseStorePath, IndexTypeCache typeCache) {
        this.filesystemFacade = filesystemFacade;
        this.baseStorePath = baseStorePath;
        this.typeCache = typeCache;
    }

    abstract IndexReference createIndexReference(IndexIdentifier var1) throws IOException, LegacyIndexNotFoundKernelException;

    abstract IndexReference refresh(IndexReference var1) throws LegacyIndexNotFoundKernelException;

    Directory getIndexDirectory(IndexIdentifier identifier) throws IOException {
        return this.filesystemFacade.getDirectory(this.baseStorePath, identifier);
    }

    IndexSearcher newIndexSearcher(IndexIdentifier identifier, IndexReader reader) throws LegacyIndexNotFoundKernelException {
        IndexSearcher searcher = new IndexSearcher(reader);
        IndexType type = this.getType(identifier);
        if (type.getSimilarity() != null) {
            searcher.setSimilarity(type.getSimilarity());
        }
        return searcher;
    }

    IndexType getType(IndexIdentifier identifier) throws LegacyIndexNotFoundKernelException {
        return this.typeCache.getIndexType(identifier, false);
    }
}

