/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.neo4j.index.impl.lucene.legacy.EntityId;
import org.neo4j.index.impl.lucene.legacy.ExactTxData;
import org.neo4j.index.impl.lucene.legacy.LowerCaseKeywordAnalyzer;
import org.neo4j.index.impl.lucene.legacy.LuceneDataSource;
import org.neo4j.index.impl.lucene.legacy.LuceneLegacyIndex;
import org.neo4j.index.impl.lucene.legacy.LuceneUtil;
import org.neo4j.index.impl.lucene.legacy.TxData;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.index.lucene.ValueContext;

public abstract class IndexType {
    public static final IndexType EXACT = new IndexType(LuceneDataSource.KEYWORD_ANALYZER, false){

        @Override
        public Query get(String key, Object value) {
            return this.queryForGet(key, value);
        }

        @Override
        void removeFieldsFromDocument(Document document, String key, Object value) {
            this.removeFieldsFromDocument(document, key, key, value);
        }

        @Override
        protected void addNewFieldToDocument(Document document, String key, Object value) {
            document.add(1.instantiateField(key, value, StringField.TYPE_STORED));
            document.add(1.instantiateSortField(key, value));
        }

        @Override
        void removeFieldFromDocument(Document document, String name) {
            document.removeFields(name);
        }

        public String toString() {
            return "EXACT";
        }
    };
    final Analyzer analyzer;
    private final boolean toLowerCase;

    private IndexType(Analyzer analyzer, boolean toLowerCase) {
        this.analyzer = analyzer;
        this.toLowerCase = toLowerCase;
    }

    abstract void removeFieldsFromDocument(Document var1, String var2, Object var3);

    abstract void removeFieldFromDocument(Document var1, String var2);

    abstract void addNewFieldToDocument(Document var1, String var2, Object var3);

    abstract Query get(String var1, Object var2);

    static IndexType getIndexType(Map<String, String> config) {
        String type = config.get("type");
        IndexType result = null;
        Similarity similarity = IndexType.getCustomSimilarity(config);
        Boolean toLowerCaseUnbiased = config.get("to_lower_case") != null ? Boolean.valueOf(IndexType.parseBoolean(config.get("to_lower_case"), true)) : null;
        Analyzer customAnalyzer = IndexType.getCustomAnalyzer(config);
        if (type != null) {
            if ("exact".equals(type)) {
                boolean toLowerCase = Boolean.TRUE.equals(toLowerCaseUnbiased);
                result = toLowerCase ? new CustomType((Analyzer)new LowerCaseKeywordAnalyzer(), true, similarity) : EXACT;
            } else if ("fulltext".equals(type)) {
                boolean toLowerCase = !Boolean.FALSE.equals(toLowerCaseUnbiased);
                Analyzer analyzer = customAnalyzer;
                if (analyzer == null) {
                    analyzer = Boolean.TRUE.equals(toLowerCase) ? LuceneDataSource.LOWER_CASE_WHITESPACE_ANALYZER : LuceneDataSource.WHITESPACE_ANALYZER;
                }
                result = new CustomType(analyzer, toLowerCase, similarity);
            }
        } else {
            boolean toLowerCase;
            boolean bl = toLowerCase = !Boolean.FALSE.equals(toLowerCaseUnbiased);
            if (customAnalyzer == null) {
                throw new IllegalArgumentException("No 'type' was given (which can point out built-in analyzers, such as 'exact' and 'fulltext') and no 'analyzer' was given either (which can point out a custom " + Analyzer.class.getName() + " to use)");
            }
            result = new CustomType(customAnalyzer, toLowerCase, similarity);
        }
        return result;
    }

    public void addToDocument(Document document, String key, Object value) {
        this.addNewFieldToDocument(document, key, value);
        this.restoreSortFields(document);
    }

    protected boolean isStoredField(IndexableField field) {
        return LuceneLegacyIndex.isValidKey(field.name()) && field.fieldType().stored() && !"__tx_state__".equals(field.name());
    }

    private static boolean parseBoolean(String string, boolean valueIfNull) {
        return string == null ? valueIfNull : Boolean.parseBoolean(string);
    }

    private static Similarity getCustomSimilarity(Map<String, String> config) {
        return IndexType.getByClassName(config, "similarity", Similarity.class);
    }

    private static Analyzer getCustomAnalyzer(Map<String, String> config) {
        return IndexType.getByClassName(config, "analyzer", Analyzer.class);
    }

    private static <T> T getByClassName(Map<String, String> config, String configKey, Class<T> cls) {
        String className = config.get(configKey);
        if (className != null) {
            try {
                return Class.forName(className).asSubclass(cls).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    TxData newTxData(LuceneLegacyIndex index) {
        return new ExactTxData(index);
    }

    Query query(String keyOrNull, Object value, QueryContext contextOrNull) {
        if (value instanceof Query) {
            return (Query)value;
        }
        QueryParser parser = new QueryParser(keyOrNull, this.analyzer);
        parser.setAllowLeadingWildcard(true);
        parser.setLowercaseExpandedTerms(this.toLowerCase);
        if (contextOrNull != null && contextOrNull.getDefaultOperator() != null) {
            parser.setDefaultOperator(contextOrNull.getDefaultOperator());
        }
        try {
            return parser.parse(value.toString());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static IndexableField instantiateField(String key, Object value, FieldType fieldType) {
        Object field;
        if (value instanceof Number) {
            Number number = (Number)value;
            field = value instanceof Long ? new LongField(key, number.longValue(), Field.Store.YES) : (value instanceof Float ? new FloatField(key, number.floatValue(), Field.Store.YES) : (value instanceof Double ? new DoubleField(key, number.doubleValue(), Field.Store.YES) : new IntField(key, number.intValue(), Field.Store.YES)));
        } else {
            field = new Field(key, value.toString(), fieldType);
        }
        return field;
    }

    public static IndexableField instantiateSortField(String key, Object value) {
        Object field;
        if (value instanceof Number) {
            Number number = (Number)value;
            field = value instanceof Float ? new SortedNumericDocValuesField(key, (long)NumericUtils.floatToSortableInt((float)number.floatValue())) : (value instanceof Double ? new SortedNumericDocValuesField(key, NumericUtils.doubleToSortableLong((double)number.doubleValue())) : new SortedNumericDocValuesField(key, number.longValue()));
        } else {
            field = "_id_".equals(key) ? new NumericDocValuesField(key, Long.parseLong(value.toString())) : new SortedSetDocValuesField(key, new BytesRef((CharSequence)value.toString()));
        }
        return field;
    }

    final void removeFromDocument(Document document, String key, Object value) {
        if (key == null && value == null) {
            this.clearDocument(document);
        } else {
            this.removeFieldsFromDocument(document, key, value);
            this.restoreSortFields(document);
        }
    }

    private void clearDocument(Document document) {
        HashSet<String> names = new HashSet<String>();
        for (IndexableField field : document.getFields()) {
            names.add(field.name());
        }
        names.remove("_id_");
        for (String name : names) {
            document.removeFields(name);
        }
    }

    void restoreSortFields(Document document) {
        Collection<IndexableField> notIndexedStoredFields = this.getNotIndexedStoredFields(document);
        for (IndexableField field : notIndexedStoredFields) {
            Object fieldValue = this.getFieldValue(field);
            String name = field.name();
            this.removeFieldsFromDocument(document, name, fieldValue);
            this.addNewFieldToDocument(document, name, fieldValue);
        }
    }

    private Collection<IndexableField> getNotIndexedStoredFields(Document document) {
        HashMap<String, IndexableField> nameFieldMap = new HashMap<String, IndexableField>();
        ArrayList<String> indexedFields = new ArrayList<String>();
        for (IndexableField field : document.getFields()) {
            if (this.isStoredField(field)) {
                nameFieldMap.put(field.name(), field);
                continue;
            }
            if (DocValuesType.NONE.equals((Object)field.fieldType().docValuesType())) continue;
            indexedFields.add(field.name());
        }
        indexedFields.forEach(nameFieldMap::remove);
        return nameFieldMap.values();
    }

    void removeFieldsFromDocument(Document document, String key, String exactKey, Object value) {
        HashSet<String> values = null;
        if (value != null) {
            String stringValue = value.toString();
            values = new HashSet<String>(Arrays.asList(document.getValues(exactKey)));
            if (!values.remove(stringValue)) {
                return;
            }
        }
        this.removeFieldFromDocument(document, key);
        if (value != null) {
            for (String existingValue : values) {
                this.addNewFieldToDocument(document, key, existingValue);
            }
        }
    }

    private Object getFieldValue(IndexableField field) {
        Number numericFieldValue = field.numericValue();
        return numericFieldValue != null ? numericFieldValue : field.stringValue();
    }

    public static Document newBaseDocument(long entityId) {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("_id_", "" + entityId, Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField("_id_", entityId));
        return doc;
    }

    public static Document newDocument(EntityId entityId) {
        Document document = IndexType.newBaseDocument(entityId.id());
        entityId.enhance(document);
        return document;
    }

    public Term idTerm(long entityId) {
        return new Term("_id_", "" + entityId);
    }

    Query idTermQuery(long entityId) {
        return new TermQuery(this.idTerm(entityId));
    }

    Similarity getSimilarity() {
        return null;
    }

    Query queryForGet(String key, Object value) {
        Object realValue;
        if (value instanceof ValueContext && (realValue = ((ValueContext)value).getValue()) instanceof Number) {
            Number number = (Number)realValue;
            return LuceneUtil.rangeQuery(key, number, number, true, true);
        }
        return new TermQuery(new Term(key, value.toString()));
    }

    private static class CustomType
    extends IndexType {
        public static final String EXACT_FIELD_SUFFIX = "_e";
        private final Similarity similarity;

        CustomType(Analyzer analyzer, boolean toLowerCase, Similarity similarity) {
            super(analyzer, toLowerCase);
            this.similarity = similarity;
        }

        @Override
        Similarity getSimilarity() {
            return this.similarity;
        }

        @Override
        public Query get(String key, Object value) {
            return new TermQuery(new Term(this.exactKey(key), value.toString()));
        }

        private String exactKey(String key) {
            return key + EXACT_FIELD_SUFFIX;
        }

        @Override
        protected void addNewFieldToDocument(Document document, String key, Object value) {
            document.add((IndexableField)new StringField(this.exactKey(key), value.toString(), Field.Store.YES));
            document.add(CustomType.instantiateField(key, value, TextField.TYPE_STORED));
            document.add(CustomType.instantiateSortField(key, value));
        }

        @Override
        void removeFieldFromDocument(Document document, String name) {
            document.removeFields(this.exactKey(name));
            document.removeFields(name);
        }

        @Override
        void removeFieldsFromDocument(Document document, String key, Object value) {
            this.removeFieldsFromDocument(document, key, this.exactKey(key), value);
        }

        @Override
        protected boolean isStoredField(IndexableField field) {
            return !field.name().endsWith(EXACT_FIELD_SUFFIX) && super.isStoredField(field);
        }

        public String toString() {
            return "FULLTEXT";
        }
    }
}

