/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.legacy;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.neo4j.index.impl.lucene.legacy.IndexIdentifier;
import org.neo4j.index.impl.lucene.legacy.IndexReference;
import org.neo4j.index.impl.lucene.legacy.IndexReferenceFactory;
import org.neo4j.index.impl.lucene.legacy.IndexTypeCache;
import org.neo4j.index.impl.lucene.legacy.LuceneDataSource;
import org.neo4j.index.impl.lucene.legacy.ReadOnlyIndexReference;
import org.neo4j.kernel.api.exceptions.legacyindex.LegacyIndexNotFoundKernelException;

public class ReadOnlyIndexReferenceFactory
extends IndexReferenceFactory {
    public ReadOnlyIndexReferenceFactory(LuceneDataSource.LuceneFilesystemFacade filesystemFacade, File baseStorePath, IndexTypeCache typeCache) {
        super(filesystemFacade, baseStorePath, typeCache);
    }

    @Override
    IndexReference createIndexReference(IndexIdentifier identifier) throws IOException, LegacyIndexNotFoundKernelException {
        DirectoryReader reader = DirectoryReader.open((Directory)this.getIndexDirectory(identifier));
        IndexSearcher indexSearcher = this.newIndexSearcher(identifier, (IndexReader)reader);
        return new ReadOnlyIndexReference(identifier, indexSearcher);
    }

    @Override
    IndexReference refresh(IndexReference indexReference) {
        return indexReference;
    }
}

