/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.result.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.RelationshipModel;
import org.neo4j.ogm.result.adapter.BaseAdapter;
import org.neo4j.ogm.result.adapter.ResultAdapter;

public abstract class RestModelAdapter
extends BaseAdapter
implements ResultAdapter<Map<String, Object>, Map<String, Object>> {
    @Override
    public Map<String, Object> adapt(Map<String, Object> result) {
        LinkedHashMap<String, Object> adaptedResults = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Collection) {
                ArrayList<Object> adaptedValues = new ArrayList<Object>();
                List values = (List)value;
                for (Object element : values) {
                    RestModelAdapter.handleAdaptedValue(adaptedValues, this.processData(element));
                }
                adaptedResults.put(entry.getKey(), adaptedValues);
                continue;
            }
            adaptedResults.put(entry.getKey(), this.processData(value));
        }
        return adaptedResults;
    }

    public static void handleAdaptedValue(Collection<Object> adaptedValues, Object newValue) {
        if (newValue instanceof Collection) {
            adaptedValues.addAll((Collection)newValue);
        } else {
            adaptedValues.add(newValue);
        }
    }

    public static Object handlePossibleCollections(Object element, Function<Object, Object> mappingFunction) {
        if (element instanceof Iterable) {
            ArrayList<Object> adaptedValues = new ArrayList<Object>();
            Iterable collection = (Iterable)element;
            for (Object nestedElement : collection) {
                RestModelAdapter.handleAdaptedValue(adaptedValues, mappingFunction.apply(nestedElement));
            }
            return adaptedValues;
        }
        return element;
    }

    private Object processData(Object element) {
        if (this.isNode(element)) {
            return this.buildNode(element);
        }
        if (this.isRelationship(element)) {
            return this.buildRelationship(element);
        }
        return RestModelAdapter.handlePossibleCollections(element, this::processData);
    }

    private NodeModel buildNode(Object node) {
        NodeModel nodeModel = new NodeModel(this.nodeId(node));
        List<String> labels = this.labels(node);
        nodeModel.setLabels(labels.toArray(new String[labels.size()]));
        nodeModel.setProperties(this.convertArrayPropertiesToCollection(this.properties(node)));
        return nodeModel;
    }

    private RelationshipModel buildRelationship(Object relationship) {
        RelationshipModel relationshipModel = new RelationshipModel();
        relationshipModel.setId(this.relationshipId(relationship));
        relationshipModel.setStartNode(this.startNodeId(relationship));
        relationshipModel.setEndNode(this.endNodeId(relationship));
        relationshipModel.setType(this.relationshipType(relationship));
        relationshipModel.setProperties(this.properties(relationship));
        return relationshipModel;
    }

    public abstract boolean isNode(Object var1);

    public abstract boolean isRelationship(Object var1);

    public abstract long nodeId(Object var1);

    public abstract List<String> labels(Object var1);

    public abstract long relationshipId(Object var1);

    public abstract String relationshipType(Object var1);

    public abstract Long startNodeId(Object var1);

    public abstract Long endNodeId(Object var1);

    public abstract Map<String, Object> properties(Object var1);
}

