/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.Value;

public abstract class FloatingPointValue
extends NumberValue {
    @Override
    public final int computeHash() {
        return NumberValues.hash(this.doubleValue());
    }

    @Override
    public boolean eq(Object other) {
        return other != null && other instanceof Value && this.equals((Value)other);
    }

    @Override
    public final boolean equals(Value other) {
        if (other instanceof FloatingPointValue) {
            FloatingPointValue that = (FloatingPointValue)other;
            return this.doubleValue() == that.doubleValue();
        }
        if (other instanceof IntegralValue) {
            IntegralValue that = (IntegralValue)other;
            return NumberValues.numbersEqual(this.doubleValue(), that.longValue());
        }
        return false;
    }

    @Override
    public NumberType numberType() {
        return NumberType.FLOATING_POINT;
    }

    @Override
    public int compareTo(IntegralValue other) {
        return NumberValues.compareDoubleAgainstLong(this.doubleValue(), other.longValue());
    }

    @Override
    public int compareTo(FloatingPointValue other) {
        return Double.compare(this.doubleValue(), other.doubleValue());
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.doubleValue());
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }
}

