/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.EdgeValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.VirtualValueGroup;
import org.neo4j.values.virtual.VirtualValues;

public abstract class PathValue
extends VirtualValue {
    public abstract NodeValue startNode();

    public abstract NodeValue endNode();

    public abstract EdgeValue lastEdge();

    public abstract NodeValue[] nodes();

    public abstract EdgeValue[] edges();

    @Override
    public boolean equals(VirtualValue other) {
        if (other == null || !(other instanceof PathValue)) {
            return false;
        }
        PathValue that = (PathValue)other;
        return this.size() == that.size() && Arrays.equals(this.nodes(), that.nodes()) && Arrays.equals(this.edges(), that.edges());
    }

    @Override
    public int computeHash() {
        NodeValue[] nodes = this.nodes();
        EdgeValue[] relationships = this.edges();
        int result = nodes[0].hashCode();
        for (int i = 1; i < nodes.length; ++i) {
            result += 31 * (result + relationships[i - 1].hashCode());
            result += 31 * (result + nodes[i].hashCode());
        }
        return result;
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        writer.writePath(this.nodes(), this.edges());
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.PATH;
    }

    @Override
    public int compareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        if (other == null || !(other instanceof PathValue)) {
            throw new IllegalArgumentException("Cannot compare different virtual values");
        }
        PathValue otherPath = (PathValue)other;
        NodeValue[] nodes = this.nodes();
        EdgeValue[] relationships = this.edges();
        NodeValue[] otherNodes = otherPath.nodes();
        EdgeValue[] otherRelationships = otherPath.edges();
        int x = nodes[0].compareTo((VirtualValue)otherNodes[0], (Comparator)comparator);
        if (x == 0) {
            int length = Math.min(relationships.length, otherRelationships.length);
            for (int i = 0; x == 0 && i < length; ++i) {
                x = relationships[i].compareTo((VirtualValue)otherRelationships[i], (Comparator)comparator);
            }
            if (x == 0) {
                x = Integer.compare(relationships.length, otherRelationships.length);
            }
        }
        return x;
    }

    public String toString() {
        int i;
        NodeValue[] nodes = this.nodes();
        EdgeValue[] relationships = this.edges();
        StringBuilder sb = new StringBuilder("Path{");
        for (i = 0; i < relationships.length; ++i) {
            sb.append(nodes[i]);
            sb.append(relationships[i]);
        }
        sb.append(nodes[i]);
        sb.append('}');
        return sb.toString();
    }

    public ListValue asList() {
        NodeValue[] nodes = this.nodes();
        EdgeValue[] relationships = this.edges();
        int size = nodes.length + relationships.length;
        AnyValue[] anyValues = new AnyValue[size];
        for (int i = 0; i < size; ++i) {
            anyValues[i] = i % 2 == 0 ? nodes[i / 2] : relationships[i / 2];
        }
        return VirtualValues.list(anyValues);
    }

    public int size() {
        return this.edges().length;
    }

    public static class DirectPathValue
    extends PathValue {
        private final NodeValue[] nodes;
        private final EdgeValue[] edges;

        DirectPathValue(NodeValue[] nodes, EdgeValue[] edges) {
            assert (nodes != null);
            assert (edges != null);
            assert (nodes.length == edges.length + 1);
            this.nodes = nodes;
            this.edges = edges;
        }

        @Override
        public NodeValue startNode() {
            return this.nodes[0];
        }

        @Override
        public NodeValue endNode() {
            return this.nodes[this.nodes.length - 1];
        }

        @Override
        public EdgeValue lastEdge() {
            assert (this.edges.length > 0);
            return this.edges[this.edges.length - 1];
        }

        @Override
        public NodeValue[] nodes() {
            return this.nodes;
        }

        @Override
        public EdgeValue[] edges() {
            return this.edges;
        }
    }
}

