/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.core.graph.pathObj;

import java.util.LinkedList;
import org.dom4j.Element;
import org.ofdrw.core.OFDElement;
import org.ofdrw.core.basicType.STBase;
import org.ofdrw.core.basicType.ST_Pos;

public class AbbreviatedData
extends OFDElement
implements Cloneable {
    private LinkedList<String[]> dataQueue;

    public AbbreviatedData(Element proxy) {
        super(proxy);
        this.dataQueue = AbbreviatedData.parse(proxy.getText());
    }

    public AbbreviatedData() {
        super("AbbreviatedData");
        this.dataQueue = new LinkedList();
    }

    public static LinkedList<String[]> parse(String txt) {
        return null;
    }

    public AbbreviatedData flush() {
        this.setText(this.toString());
        return this;
    }

    public AbbreviatedData defineStart(double x, double y) {
        this.dataQueue.add(new String[]{"S", " ", STBase.fmt(x), " ", STBase.fmt(y)});
        return this;
    }

    public AbbreviatedData s(ST_Pos start) {
        return this.defineStart(start.getX(), start.getY());
    }

    public AbbreviatedData S(double x, double y) {
        return this.defineStart(x, y);
    }

    public AbbreviatedData moveTo(double x, double y) {
        this.dataQueue.add(new String[]{"M", " ", STBase.fmt(x), " ", STBase.fmt(y)});
        return this;
    }

    public AbbreviatedData M(double x, double y) {
        return this.moveTo(x, y);
    }

    public AbbreviatedData M(ST_Pos target) {
        return this.moveTo(target.getX(), target.getY());
    }

    public AbbreviatedData lineTo(double x, double y) {
        this.dataQueue.add(new String[]{"L", " ", STBase.fmt(x), " ", STBase.fmt(y)});
        return this;
    }

    public AbbreviatedData L(double x, double y) {
        return this.lineTo(x, y);
    }

    public AbbreviatedData L(ST_Pos p) {
        return this.lineTo(p.getX(), p.getY());
    }

    public AbbreviatedData quadraticBezier(double x1, double y1, double x2, double y2) {
        this.dataQueue.add(new String[]{"Q", " ", STBase.fmt(x1), " ", STBase.fmt(y1), " ", STBase.fmt(x2), " ", STBase.fmt(y2)});
        return this;
    }

    public AbbreviatedData Q(double x1, double y1, double x2, double y2) {
        return this.quadraticBezier(x1, y1, x2, y2);
    }

    public AbbreviatedData Q(ST_Pos control, ST_Pos target) {
        return this.quadraticBezier(control.getX(), control.getY(), target.getX(), target.getY());
    }

    public AbbreviatedData cubicBezier(double x1, double y1, double x2, double y2, double x3, double y3) {
        this.dataQueue.add(new String[]{"B", " ", STBase.fmt(x1), " ", STBase.fmt(y1), " ", STBase.fmt(x2), " ", STBase.fmt(y2), " ", STBase.fmt(x3), " ", STBase.fmt(y3)});
        return this;
    }

    public AbbreviatedData B(double x1, double y1, double x2, double y2, double x3, double y3) {
        return this.cubicBezier(x1, y1, x2, y2, x3, y3);
    }

    public AbbreviatedData B(ST_Pos control1, ST_Pos control2, ST_Pos target) {
        return this.cubicBezier(control1.getX(), control1.getY(), control2.getX(), control2.getY(), target.getX(), target.getY());
    }

    public AbbreviatedData arc(double rx, double ry, double angle, int large, int sweep, double x, double y) {
        if (large != 0 && large != 1) {
            throw new NumberFormatException("large \u53ea\u63a5\u53d7 0 \u6216 1");
        }
        if (sweep != 0 && sweep != 1) {
            throw new NumberFormatException("sweep \u53ea\u63a5\u53d7 0 \u6216 1");
        }
        this.dataQueue.add(new String[]{"A", " ", STBase.fmt(rx), " ", STBase.fmt(ry), " ", STBase.fmt(angle), " ", STBase.fmt(large), " ", STBase.fmt(sweep), " ", STBase.fmt(x), " ", STBase.fmt(y)});
        return this;
    }

    public AbbreviatedData A(double rx, double ry, double angle, int large, int sweep, double x, double y) {
        return this.arc(rx, ry, angle, large, sweep, x, y);
    }

    public AbbreviatedData A(double rx, double ry, double angle, int large, int sweep, ST_Pos target) {
        return this.arc(rx, ry, angle, large, sweep, target.getX(), target.getY());
    }

    public AbbreviatedData close() {
        this.dataQueue.add(new String[]{"C"});
        return this;
    }

    public AbbreviatedData C() {
        return this.close();
    }

    public AbbreviatedData undo() {
        this.dataQueue.removeLast();
        return this;
    }

    public String toString() {
        if (this.dataQueue.size() == 0) {
            throw new IllegalArgumentException("AbbreviatedData \u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder dataBuilder = new StringBuilder();
        int cnt = 0;
        for (String[] operatorItem : this.dataQueue) {
            if (++cnt != 1) {
                dataBuilder.append(" ");
            }
            for (String item : operatorItem) {
                dataBuilder.append(item);
            }
        }
        return dataBuilder.toString();
    }

    @Override
    public AbbreviatedData clone() {
        AbbreviatedData clone = new AbbreviatedData();
        clone.dataQueue = new LinkedList();
        for (String[] item : this.dataQueue) {
            clone.dataQueue.add((String[])item.clone());
        }
        return clone;
    }
}

