/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.core.pageDescription;

import org.dom4j.Element;
import org.ofdrw.core.OFDElement;
import org.ofdrw.core.action.Actions;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_RefID;
import org.ofdrw.core.pageDescription.clips.Clips;
import org.ofdrw.core.pageDescription.drawParam.LineCapType;
import org.ofdrw.core.pageDescription.drawParam.LineJoinType;

public abstract class CT_GraphicUnit<T extends CT_GraphicUnit>
extends OFDElement {
    public CT_GraphicUnit(Element proxy) {
        super(proxy);
    }

    public CT_GraphicUnit(String name) {
        super(name);
    }

    public T setBoundary(ST_Box boundary) {
        if (boundary == null) {
            throw new IllegalArgumentException("\u5916\u63a5\u77e9\u5f62\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.addAttribute("Boundary", boundary.toString());
        return (T)this;
    }

    public T setBoundary(double topLeftX, double topLeftY, double width, double height) {
        ST_Box boundary = new ST_Box(topLeftX, topLeftY, width, height);
        return this.setBoundary(boundary);
    }

    public ST_Box getBoundary() {
        return ST_Box.getInstance(this.attributeValue("Boundary"));
    }

    public T setGraphicName(String name) {
        if (name == null || name.trim().length() == 0) {
            this.removeAttr("Name");
            return (T)this;
        }
        this.addAttribute("Name", name);
        return (T)this;
    }

    public String getGraphicName() {
        return this.attributeValue("Name");
    }

    public T setVisible(Boolean visible) {
        if (visible == null) {
            this.removeAttr("Visible");
            return (T)this;
        }
        this.addAttribute("Visible", visible.toString());
        return (T)this;
    }

    public Boolean getVisible() {
        String str = this.attributeValue("Visible");
        if (str == null || str.trim().length() == 0) {
            return true;
        }
        return Boolean.parseBoolean(str);
    }

    public T setCTM(ST_Array ctm) {
        this.addAttribute("CTM", ctm.toString());
        return (T)this;
    }

    public ST_Array getCTM() {
        return ST_Array.getInstance(this.attributeValue("CTM"));
    }

    public T setDrawParam(ST_RefID id) {
        this.addAttribute("DrawParam", id.toString());
        return (T)this;
    }

    public ST_RefID getDrawParam() {
        return ST_RefID.getInstance(this.attributeValue("DrawParam"));
    }

    public T setLineWidth(Double lineWidth) {
        if (lineWidth == null) {
            this.removeAttr("LineWidth");
            return (T)this;
        }
        this.addAttribute("LineWidth", lineWidth.toString());
        return (T)this;
    }

    public Double getLineWidth() {
        String str = this.attributeValue("LineWidth");
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return Double.parseDouble(str);
    }

    public T setCap(LineCapType cap) {
        if (cap == null) {
            this.removeAttr("Cap");
            return (T)this;
        }
        this.addAttribute("Cap", cap.toString());
        return (T)this;
    }

    public LineCapType getCap() {
        return LineCapType.getInstance(this.attributeValue("Cap"));
    }

    public T setJoin(LineJoinType join) {
        if (join == null) {
            this.removeAttr("Join");
            return (T)this;
        }
        this.addAttribute("Join", join.toString());
        return (T)this;
    }

    public LineJoinType getJoin() {
        return LineJoinType.getInstance(this.attributeValue("Join"));
    }

    public T setMiterLimit(Double miterLimit) {
        if (miterLimit == null) {
            this.removeAttr("MiterLimit");
            return (T)this;
        }
        this.addAttribute("MiterLimit", miterLimit.toString());
        return (T)this;
    }

    public Double getMiterLimit() {
        String str = this.attributeValue("MiterLimit");
        if (str == null || str.trim().length() == 0) {
            return 3.528;
        }
        return Double.parseDouble(str);
    }

    public T setDashOffset(Double dashOffset) {
        if (dashOffset == null) {
            this.removeAttr("DashOffset");
            return (T)this;
        }
        this.addAttribute("DashOffset", dashOffset.toString());
        return (T)this;
    }

    public Double getDashOffset() {
        String str = this.attributeValue("DashOffset");
        if (str == null || str.trim().length() == 0) {
            return 0.0;
        }
        return Double.parseDouble(str);
    }

    public T setDashPattern(ST_Array dashPattern) {
        if (dashPattern == null) {
            this.removeAttr("DashPattern");
            return (T)this;
        }
        this.addAttribute("DashPattern", dashPattern.toString());
        return (T)this;
    }

    public ST_Array getDashPattern() {
        return ST_Array.getInstance(this.attributeValue("DashPattern"));
    }

    public T setAlpha(Integer alpha) {
        if (alpha == null) {
            this.removeAttr("Alpha");
            return (T)this;
        }
        if (alpha < 0) {
            alpha = 0;
        }
        if (alpha > 255) {
            alpha = 255;
        }
        this.addAttribute("Alpha", alpha.toString());
        return (T)this;
    }

    public Integer getAlpha() {
        String str = this.attributeValue("Alpha");
        if (str == null || str.trim().length() == 0) {
            return 0;
        }
        return Integer.parseInt(str);
    }

    public T setActions(Actions actions) {
        this.add(actions);
        return (T)this;
    }

    public Actions getActions() {
        Element e = this.getOFDElement("Actions");
        return e == null ? null : new Actions(e);
    }

    public CT_GraphicUnit setClips(Clips clips) {
        if (clips == null) {
            return this;
        }
        this.add(clips);
        return this;
    }

    public Clips getClips() {
        Element e = this.getOFDElement("Clips");
        return e == null ? null : new Clips(e);
    }
}

