/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.core.attachment;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import org.dom4j.Element;
import org.ofdrw.core.Const;
import org.ofdrw.core.OFDElement;
import org.ofdrw.core.basicType.STBase;
import org.ofdrw.core.basicType.ST_Loc;

public class CT_Attachment
extends OFDElement {
    public CT_Attachment(Element proxy) {
        super(proxy);
    }

    public CT_Attachment() {
        super("Attachment");
    }

    public CT_Attachment setID(String id) {
        if (id == null || id.trim().length() == 0) {
            throw new IllegalArgumentException("\u9644\u4ef6\u6807\u8bc6\uff08ID\uff09\u4e3a\u7a7a");
        }
        this.addAttribute("ID", id);
        return this;
    }

    public String getID() {
        String str = this.attributeValue("ID");
        if (str == null || str.trim().length() == 0) {
            throw new IllegalArgumentException("\u9644\u4ef6\u6807\u8bc6\uff08ID\uff09\u4e3a\u7a7a");
        }
        return str;
    }

    public CT_Attachment setAttachmentName(String attachmentName) {
        if (attachmentName == null || attachmentName.trim().length() == 0) {
            throw new IllegalArgumentException("\u9644\u4ef6\u540d\u79f0\uff08Name\uff09\u4e3a\u7a7a");
        }
        this.addAttribute("Name", attachmentName);
        return this;
    }

    public String getAttachmentName() {
        String str = this.attributeValue("Name");
        if (str == null || str.trim().length() == 0) {
            throw new IllegalArgumentException("\u9644\u4ef6\u540d\u79f0\uff08Name\uff09\u4e3a\u7a7a");
        }
        return str;
    }

    public CT_Attachment setFormat(String format) {
        if (format == null || format.trim().length() == 0) {
            this.removeAttr("Format");
            return this;
        }
        this.addAttribute("Format", format);
        return this;
    }

    public String getFormat() {
        return this.attributeValue("Format");
    }

    @Deprecated
    public CT_Attachment setCreationDate(LocalDate creationDate) {
        if (creationDate == null) {
            this.removeAttr("CreationDate");
            return this;
        }
        this.addAttribute("CreationDate", creationDate.atStartOfDay().format(Const.DATETIME_FORMATTER));
        return this;
    }

    public CT_Attachment setCreationDate(LocalDateTime creationDate) {
        if (creationDate == null) {
            this.removeAttr("CreationDate");
            return this;
        }
        this.addAttribute("CreationDate", creationDate.format(Const.DATETIME_FORMATTER));
        return this;
    }

    @Deprecated
    public LocalDate getCreationDate() {
        String str = this.attributeValue("CreationDate");
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        str = str.trim();
        try {
            return this.parseLocalDateTime(str).toLocalDate();
        }
        catch (Exception ignore) {
            return LocalDate.parse(str, Const.DATE_FORMATTER);
        }
    }

    public LocalDateTime getCreationDateTime() {
        String str = this.attributeValue("CreationDate");
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        str = str.trim();
        try {
            return this.parseLocalDateTime(str);
        }
        catch (Exception ignore) {
            return LocalDate.parse(str, Const.DATE_FORMATTER).atStartOfDay();
        }
    }

    @Deprecated
    public CT_Attachment setModDate(LocalDate modDate) {
        if (modDate == null) {
            this.removeAttr("ModDate");
            return this;
        }
        this.addAttribute("ModDate", modDate.atStartOfDay().format(Const.DATETIME_FORMATTER));
        return this;
    }

    public CT_Attachment setModDate(LocalDateTime modDate) {
        if (modDate == null) {
            this.removeAttr("ModDate");
            return this;
        }
        this.addAttribute("ModDate", modDate.format(Const.DATETIME_FORMATTER));
        return this;
    }

    @Deprecated
    public LocalDate getModDate() {
        String str = this.attributeValue("ModDate");
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        str = str.trim();
        try {
            return this.parseLocalDateTime(str).toLocalDate();
        }
        catch (Exception ignore) {
            return LocalDate.parse(str, Const.DATE_FORMATTER);
        }
    }

    public LocalDateTime getModDateTime() {
        String str = this.attributeValue("ModDate");
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        str = str.trim();
        try {
            return this.parseLocalDateTime(str);
        }
        catch (Exception ignore) {
            return LocalDate.parse(str, Const.DATE_FORMATTER).atStartOfDay();
        }
    }

    private LocalDateTime parseLocalDateTime(String dateTimeStr) {
        List<DateTimeFormatter> formatters = Arrays.asList(Const.LOCAL_DATETIME_FORMATTER, DateTimeFormatter.ofPattern("[yyyy-MM-dd][yyyy/MM/dd] HH:mm:ss"), Const.DATETIME_FORMATTER);
        for (DateTimeFormatter formatter : formatters) {
            try {
                return LocalDateTime.parse(dateTimeStr, formatter);
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalArgumentException("\u65e5\u671f\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a" + dateTimeStr);
    }

    public CT_Attachment setSize(Double size) {
        if (size == null) {
            this.removeAttr("Size");
            return this;
        }
        this.addAttribute("Size", STBase.fmt(size));
        return this;
    }

    public Double getSize() {
        String str = this.attributeValue("Size");
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return Double.parseDouble(str);
    }

    public CT_Attachment setVisible(Boolean visible) {
        if (visible == null) {
            this.removeAttr("Visible");
            return this;
        }
        this.addAttribute("Visible", Boolean.toString(visible));
        return this;
    }

    public Boolean getVisible() {
        String str = this.attributeValue("Visible");
        if (str == null || str.trim().length() == 0) {
            return true;
        }
        return Boolean.parseBoolean(str);
    }

    public CT_Attachment setUsage(String usage) {
        if (usage == null || usage.trim().length() == 0) {
            this.removeAttr("Usage");
            return this;
        }
        this.addAttribute("Usage", usage);
        return this;
    }

    public String getUsage() {
        String str = this.attributeValue("Usage");
        if (str == null || str.trim().length() == 0) {
            return "none";
        }
        return str;
    }

    public CT_Attachment setFileLoc(ST_Loc fileLoc) {
        if (fileLoc == null) {
            this.removeOFDElemByNames("FileLoc");
            return this;
        }
        this.setOFDEntity("FileLoc", fileLoc);
        return this;
    }

    public ST_Loc getFileLoc() {
        Element e = this.getOFDElement("FileLoc");
        return e == null ? null : ST_Loc.getInstance(e);
    }
}

