/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.core.integrity;

import java.io.Serializable;
import java.time.LocalDateTime;
import org.dom4j.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ofdrw.core.Const;
import org.ofdrw.core.OFDElement;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.integrity.FileList;

public class OFDEntries
extends OFDElement {
    public OFDEntries(Element proxy) {
        super(proxy);
    }

    public OFDEntries() {
        super("DocEntries");
    }

    public OFDEntries setID(String id) {
        this.addAttribute("ID", id);
        return this;
    }

    public String getID() {
        return this.attributeValue("ID");
    }

    public OFDEntries setCreatorName(String creatorName) {
        if (creatorName == null) {
            this.removeAttr("CreatorName");
            return this;
        }
        this.addAttribute("CreatorName", creatorName);
        return this;
    }

    @Nullable
    public String getCreatorName() {
        return this.attributeValue("CreatorName");
    }

    public OFDEntries setVersion(String version) {
        if (version == null) {
            this.removeAttr("Version");
            return this;
        }
        this.addAttribute("Version", version);
        return this;
    }

    @Nullable
    public String getVersion() {
        return this.attributeValue("Version");
    }

    public OFDEntries setCreationDate(LocalDateTime creationDate) {
        if (creationDate == null) {
            this.removeAttr("CreationDate");
            return this;
        }
        this.addAttribute("CreationDate", creationDate.format(Const.DATE_FORMATTER));
        return this;
    }

    @Nullable
    public LocalDateTime getCreationDate() {
        String str = this.attributeValue("CreationDate");
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return LocalDateTime.parse(str, Const.DATETIME_FORMATTER);
    }

    public OFDEntries setSignedValueLoc(@NotNull ST_Loc signedValueLoc) {
        if (signedValueLoc == null) {
            throw new IllegalArgumentException("\u9632\u5939\u5e26\u6587\u4ef6\u5f62\u6210\u7684\u7b7e\u540d\u503c(signedValueLoc)\u4e3a\u7a7a");
        }
        this.setOFDEntity("SignedValueLoc", (Serializable)((Object)signedValueLoc.toString()));
        return this;
    }

    @NotNull
    public ST_Loc getSignedValueLoc() {
        Element e = this.getOFDElement("SignedValueLoc");
        if (e == null) {
            throw new IllegalArgumentException("\u9632\u5939\u5e26\u6587\u4ef6\u5f62\u6210\u7684\u7b7e\u540d\u503c(signedValueLoc)\u4e3a\u7a7a");
        }
        return new ST_Loc(e.getTextTrim());
    }

    public OFDEntries setFileList(@NotNull FileList fileList) {
        if (fileList == null) {
            throw new IllegalArgumentException("\u9632\u6b62\u5939\u5e26\u6587\u4ef6\u5217\u8868(FileList)\u4e3a\u7a7a");
        }
        this.set(fileList);
        return this;
    }

    @NotNull
    public FileList getFileList() {
        Element e = this.getOFDElement("FileList");
        if (e == null) {
            throw new IllegalArgumentException("\u9632\u6b62\u5939\u5e26\u6587\u4ef6\u5217\u8868(FileList)\u4e3a\u7a7a");
        }
        return new FileList(e);
    }
}

