/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.reader.tools;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.jbig2.JBIG2ImageReader;
import org.apache.pdfbox.jbig2.JBIG2ImageReaderSpi;
import org.apache.pdfbox.jbig2.io.DefaultInputStreamFactory;

public class ImageUtils {
    public static byte[] toBytes(BufferedImage bufferedImage, String type) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean flag = ImageIO.write((RenderedImage)bufferedImage, type, out);
        byte[] bytes = out.toByteArray();
        return bytes;
    }

    public static BufferedImage readJB2(InputStream in) throws IOException {
        int imageIndex = 0;
        JBIG2ImageReader imageReader = null;
        DefaultInputStreamFactory disf = new DefaultInputStreamFactory();
        ImageInputStream imageInputStream = disf.getInputStream(in);
        imageReader = new JBIG2ImageReader((ImageReaderSpi)new JBIG2ImageReaderSpi());
        imageReader.setInput((Object)imageInputStream);
        return imageReader.read(imageIndex, (ImageReadParam)imageReader.getDefaultReadParam());
    }

    public static BufferedImage renderMask(BufferedImage image, BufferedImage mask) {
        if (image.getWidth() != mask.getWidth() || image.getHeight() != mask.getHeight()) {
            return image;
        }
        return ImageUtils.renderMask(image, mask, (r, g, b) -> (r + g + b) / 3 > 244);
    }

    private static BufferedImage renderMask(BufferedImage image, BufferedImage mask, PixelFilter pixelFilter) {
        BufferedImage out = ImageUtils.createImage(image.getWidth(), image.getHeight(), true);
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int rgb = mask.getRGB(x, y);
                int r = 0xFF & rgb;
                int g = 0xFF00 & rgb;
                int b = 0xFF0000 & rgb;
                boolean sholdMask = pixelFilter.filter(r, g >>= 8, b >>= 16);
                if (!sholdMask) continue;
                out.setRGB(x, y, image.getRGB(x, y));
            }
        }
        return out;
    }

    public static int gray(int r, int g, int b) {
        return r * 19595 + g * 38469 + b * 7472 >> 16;
    }

    public static BufferedImage createImage(int width, int height, boolean isTransparent) {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setComposite(AlphaComposite.getInstance(10, 1.0f));
        if (isTransparent) {
            graphics.setColor(Color.WHITE);
            image = graphics.getDeviceConfiguration().createCompatibleImage(image.getWidth(), image.getHeight(), 3);
        } else {
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        }
        return image;
    }

    public static BufferedImage clearWhiteBackground(BufferedImage in, int gray) {
        return ImageUtils.renderMask(in, in, (r, g, b) -> ImageUtils.gray(r, g, b) < gray);
    }

    private static interface PixelFilter {
        public boolean filter(int var1, int var2, int var3);
    }
}

