/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.tool.merge;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.bouncycastle.jcajce.provider.digest.SM3;
import org.bouncycastle.util.encoders.Hex;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.ofdrw.core.OFDElement;
import org.ofdrw.core.annotation.Annotations;
import org.ofdrw.core.annotation.pageannot.AnnPage;
import org.ofdrw.core.annotation.pageannot.PageAnnot;
import org.ofdrw.core.basicStructure.doc.CT_PageArea;
import org.ofdrw.core.basicStructure.doc.Document;
import org.ofdrw.core.basicStructure.pageObj.CT_TemplatePage;
import org.ofdrw.core.basicStructure.pageObj.Page;
import org.ofdrw.core.basicStructure.pageObj.Template;
import org.ofdrw.core.basicStructure.pageTree.Pages;
import org.ofdrw.core.basicStructure.res.CT_MultiMedia;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.basicType.ST_RefID;
import org.ofdrw.core.compositeObj.CT_VectorG;
import org.ofdrw.core.pageDescription.color.colorSpace.CT_ColorSpace;
import org.ofdrw.core.pageDescription.drawParam.CT_DrawParam;
import org.ofdrw.core.text.font.CT_Font;
import org.ofdrw.pkg.container.AnnotsDir;
import org.ofdrw.pkg.container.PageDir;
import org.ofdrw.pkg.container.PagesDir;
import org.ofdrw.pkg.container.ResDir;
import org.ofdrw.reader.ResourceLocator;
import org.ofdrw.reader.model.TemplatePageEntity;
import org.ofdrw.tool.merge.BareOFDDoc;
import org.ofdrw.tool.merge.DocContext;
import org.ofdrw.tool.merge.PageEntry;

public class OFDMerger
implements Closeable {
    public final ArrayList<PageEntry> pageArr;
    private final Map<String, DocContext> docCtxMap;
    private final Path dest;
    private BareOFDDoc ofdDoc;
    private Annotations newDocAnnotations = null;
    private AnnotsDir annotsDir = null;
    private final Map<String, ST_Loc> resFileHashTable;
    private final Map<String, CT_TemplatePage> tplPageMap;
    private final AtomicInteger resFileCounter;
    private static final Map<String, XPath> AttrQueries = new HashMap<String, XPath>(){
        {
            this.put("Font", DocumentHelper.createXPath((String)"//*[@Font]"));
            this.put("ResourceID", DocumentHelper.createXPath((String)"//*[@ResourceID]"));
            this.put("Substitution", DocumentHelper.createXPath((String)"//*[@Substitution]"));
            this.put("ImageMask", DocumentHelper.createXPath((String)"//*[@ImageMask]"));
            this.put("Thumbnail", DocumentHelper.createXPath((String)"//*[@Thumbnail]"));
            this.put("DrawParam", DocumentHelper.createXPath((String)"//*[@DrawParam]"));
            this.put("ColorSpace", DocumentHelper.createXPath((String)"//*[@ColorSpace]"));
        }
    };

    public OFDMerger(Path dest) {
        if (dest == null) {
            throw new IllegalArgumentException("\u5408\u5e76\u7ed3\u679c\u8def\u5f84(dest)\u4e3a\u7a7a");
        }
        this.pageArr = new ArrayList(10);
        this.docCtxMap = new HashMap<String, DocContext>();
        this.dest = dest;
        Path parent = dest.getParent();
        if (parent == null || !Files.exists(parent, new LinkOption[0])) {
            throw new IllegalArgumentException("OFD\u6587\u4ef6\u5b58\u50a8\u8def\u5f84(dest)\u4e0a\u7ea7\u76ee\u5f55 [" + parent + "] \u4e0d\u5b58\u5728");
        }
        this.resFileHashTable = new HashMap<String, ST_Loc>(3);
        this.tplPageMap = new HashMap<String, CT_TemplatePage>(2);
        this.resFileCounter = new AtomicInteger(0);
    }

    public OFDMerger add(Path filepath, int ... pageIndexes) throws IOException {
        String key = filepath.toAbsolutePath().getFileName().toString();
        DocContext ctx = this.docCtxMap.get(key);
        if (ctx == null) {
            ctx = new DocContext(filepath);
            this.docCtxMap.put(key, ctx);
        }
        if (pageIndexes == null || pageIndexes.length == 0) {
            int numberOfPages = ctx.reader.getNumberOfPages();
            pageIndexes = new int[numberOfPages];
            for (int i = 0; i < pageIndexes.length; ++i) {
                pageIndexes[i] = i + 1;
            }
        }
        for (int pageIndex : pageIndexes) {
            this.pageArr.add(new PageEntry(pageIndex, ctx));
        }
        return this;
    }

    public OFDMerger add(PageEntry ... pages) {
        if (pages == null) {
            return this;
        }
        for (PageEntry page : pages) {
            if (page.docCtx == null || page.docCtx.filepath == null) continue;
            String key = page.docCtx.filepath.toAbsolutePath().getFileName().toString();
            if (!this.docCtxMap.containsKey(key)) {
                this.docCtxMap.put(key, page.docCtx);
            }
            this.pageArr.add(page);
        }
        return this;
    }

    private void doMerge() throws IOException, DocumentException {
        if (Files.exists(this.dest, new LinkOption[0])) {
            Files.delete(this.dest);
        }
        try (BareOFDDoc ofdDoc = new BareOFDDoc(this.dest);){
            this.ofdDoc = ofdDoc;
            Pages pages = ofdDoc.document.getPages();
            PagesDir pagesDir = ofdDoc.docDir.obtainPages();
            for (PageEntry pageEntry : this.pageArr) {
                CT_PageArea docDefaultArea = new CT_PageArea((Element)pageEntry.docCtx.getDefaultArea(0).clone());
                Page page = null;
                ST_ID oldPageID = null;
                ST_ID newPageID = null;
                try {
                    oldPageID = pageEntry.docCtx.reader.getPageObjectId(pageEntry.pageIndex.intValue());
                    Element copy = (Element)pageEntry.docCtx.reader.getPage(pageEntry.pageIndex.intValue()).clone();
                    org.dom4j.Document document = DocumentHelper.createDocument();
                    document.add(copy);
                    page = new Page(copy);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                if (page.getArea() == null) {
                    page.setArea(docDefaultArea);
                }
                PageDir pageDir = pagesDir.newPageDir();
                String pageLoc = String.format("Pages/Page_%d/Content.xml", pageDir.getIndex());
                org.ofdrw.core.basicStructure.pageTree.Page newPageItem = new org.ofdrw.core.basicStructure.pageTree.Page((long)this.ofdDoc.MaxUnitID.incrementAndGet(), pageLoc);
                pages.addPage(newPageItem);
                newPageID = newPageItem.getID();
                if (pageEntry.copyTemplate) {
                    List pageTplArr = page.getTemplates();
                    for (Template tplObj : pageTplArr) {
                        ST_RefID tplNewId = this.pageTplMigrate(pageEntry.docCtx, tplObj);
                        tplObj.setTemplateID(tplNewId);
                    }
                }
                this.domMigrate(pageEntry.docCtx, (Element)page);
                pageDir.setContent(page);
                if (!pageEntry.copyAnnotations || oldPageID == null || newPageID == null) continue;
                String pageDirName = pageDir.getContainerName();
                this.pageAnnotationMigrate(pageEntry.docCtx, oldPageID, newPageID, pageDirName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pageAnnotationMigrate(DocContext docCtx, ST_ID oldPageID, ST_ID newPageID, String pageAnnotDirName) throws IOException {
        ResourceLocator rl = docCtx.reader.getResourceLocator();
        try {
            rl.save();
            Document srcDoc = docCtx.reader.cdDefaultDoc();
            ST_Loc srcAnnotListPath = srcDoc.getAnnotations();
            if (srcAnnotListPath == null || !rl.exist(srcAnnotListPath.toString())) {
                return;
            }
            Annotations annotList = (Annotations)rl.get(srcAnnotListPath, Annotations::new);
            if (annotList == null) {
                return;
            }
            AnnPage annPage = annotList.getByPageId(oldPageID.toString());
            if (annPage == null || annPage.getFileLoc() == null) {
                return;
            }
            rl.cd(srcAnnotListPath.parent());
            PageAnnot pageAnnot = (PageAnnot)rl.get(annPage.getFileLoc(), PageAnnot::new);
            if (pageAnnot == null) {
                return;
            }
            Element copy = (Element)pageAnnot.clone();
            org.dom4j.Document document = DocumentHelper.createDocument();
            document.add(copy);
            pageAnnot = new PageAnnot(copy);
            if (this.newDocAnnotations == null) {
                this.annotsDir = this.ofdDoc.docDir.obtainAnnots();
                this.newDocAnnotations = new Annotations();
                this.annotsDir.setAnnotations(this.newDocAnnotations);
                this.ofdDoc.document.setAnnotations(this.annotsDir.getAbsLoc().cat("Annotations.xml"));
            }
            PageDir pageDir = (PageDir)this.annotsDir.obtainContainer(pageAnnotDirName, PageDir::new);
            ST_Loc pageAnnotPath = pageDir.addAnnot(pageAnnot);
            AnnPage annotItem = new AnnPage().setPageID(newPageID).setFileLoc(pageAnnotPath);
            this.newDocAnnotations.addPage(annotItem);
            this.domMigrate(docCtx, (Element)pageAnnot);
        }
        catch (FileNotFoundException | DocumentException e) {
            System.err.println("\u9875\u9762\u6ce8\u91ca\u8fc1\u79fb\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            rl.restore();
        }
    }

    private ST_RefID pageTplMigrate(DocContext docCtx, Template tplObj) throws IOException {
        String oldId = tplObj.getTemplateID().toString();
        CT_TemplatePage templatePage = this.tplPageMap.get(oldId);
        if (templatePage != null && templatePage.asXML().equals(tplObj.asXML())) {
            return templatePage.getID().ref();
        }
        TemplatePageEntity entity = docCtx.reader.getTemplate(oldId);
        Page pageObj = entity.getPage();
        Element copy = (Element)pageObj.clone();
        org.dom4j.Document document = DocumentHelper.createDocument();
        document.add(copy);
        pageObj = new Page(copy);
        templatePage = entity.getTplInfo();
        templatePage.setParent(null);
        this.domMigrate(docCtx, (Element)pageObj);
        ST_Loc tplPageLoc = this.ofdDoc.docDir.obtainTemps().add(pageObj);
        templatePage.setBaseLoc(tplPageLoc);
        ST_ID newId = new ST_ID((long)this.ofdDoc.MaxUnitID.incrementAndGet());
        templatePage.setID(newId);
        this.ofdDoc.cdata.addTemplatePage(templatePage);
        this.tplPageMap.put(oldId, templatePage);
        return newId.ref();
    }

    private void domMigrate(DocContext docCtx, Element dom) throws IOException {
        for (Map.Entry<String, XPath> entry : AttrQueries.entrySet()) {
            List nodes = entry.getValue().selectNodes((Object)dom);
            if (nodes.isEmpty()) continue;
            String attrName = entry.getKey();
            for (Node node : nodes) {
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                String oldResId = element.attributeValue(attrName);
                long newResId = this.resMigrate(docCtx, oldResId);
                element.addAttribute(attrName, Long.toString(newResId));
            }
        }
        List objArr = dom.selectNodes("//*[@ID]");
        for (Node node : objArr) {
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            element.addAttribute("ID", Integer.toString(this.ofdDoc.MaxUnitID.incrementAndGet()));
        }
    }

    private long resMigrate(DocContext docCtx, String oldResId) throws IOException {
        OFDElement resObj = docCtx.resMgt.get(oldResId);
        if (resObj == null) {
            return 0L;
        }
        ResourceLocator rl = docCtx.reader.getResourceLocator();
        OFDElement cache = docCtx.resOldNewMap.get(oldResId);
        if (cache != null) {
            return cache.getObjID().getId();
        }
        docCtx.resOldNewMap.put(oldResId, resObj);
        resObj.setParent(null);
        if (resObj instanceof CT_ColorSpace) {
            CT_ColorSpace cs = (CT_ColorSpace)resObj;
            ST_Loc profile = cs.getProfile();
            if (profile != null) {
                Path filepath = rl.getFile(profile);
                profile = this.copyResFile(filepath);
                cs.setProfile(profile);
            }
            this.ofdDoc.prm.addRawWithCache((OFDElement)cs);
        } else if (resObj instanceof CT_DrawParam) {
            CT_DrawParam dp = (CT_DrawParam)resObj;
            this.ofdDoc.prm.addRawWithCache((OFDElement)dp);
        } else if (resObj instanceof CT_Font) {
            CT_Font f = (CT_Font)resObj;
            ST_Loc fontFileLoc = f.getFontFile();
            if (fontFileLoc != null) {
                Path filepath = rl.getFile(fontFileLoc);
                fontFileLoc = this.copyResFile(filepath);
                f.setFontFile(fontFileLoc);
            }
            this.ofdDoc.prm.addRawWithCache((OFDElement)f);
        } else if (resObj instanceof CT_MultiMedia) {
            CT_MultiMedia mm = (CT_MultiMedia)resObj;
            ST_Loc mediaFileLoc = mm.getMediaFile();
            if (mediaFileLoc != null) {
                Path filepath = rl.getFile(mediaFileLoc);
                mediaFileLoc = this.copyResFile(filepath);
                mm.setMediaFile(mediaFileLoc);
            }
            this.ofdDoc.prm.addRawWithCache((OFDElement)mm);
        } else if (resObj instanceof CT_VectorG) {
            CT_VectorG vg = (CT_VectorG)resObj;
            org.dom4j.Document d = DocumentHelper.createDocument();
            d.add((Element)vg);
            this.domMigrate(docCtx, (Element)vg);
            this.ofdDoc.prm.addRawWithCache((OFDElement)vg);
        } else {
            return 0L;
        }
        return resObj.getObjID().getId();
    }

    private ST_Loc copyResFile(Path filepath) throws IOException {
        SM3.Digest digest = new SM3.Digest();
        byte[] buff = new byte[4096];
        int n = 0;
        try (InputStream in = Files.newInputStream(filepath, new OpenOption[0]);){
            while ((n = in.read(buff)) != -1) {
                digest.update(buff, 0, n);
            }
        }
        String hash = Hex.toHexString((byte[])digest.digest());
        ST_Loc resLoc = this.resFileHashTable.get(hash);
        if (resLoc != null) {
            return resLoc;
        }
        String fileName = filepath.getFileName().toString();
        int off = fileName.lastIndexOf(46);
        fileName = off != -1 ? this.resFileCounter.incrementAndGet() + fileName.substring(off) : Integer.toString(this.resFileCounter.incrementAndGet());
        ResDir resDir = this.ofdDoc.docDir.obtainRes();
        try (InputStream in = Files.newInputStream(filepath, new OpenOption[0]);){
            resDir.addRaw(fileName, in);
        }
        ST_Loc res = new ST_Loc(fileName);
        this.resFileHashTable.put(hash, res);
        return res;
    }

    @Override
    public void close() throws IOException {
        if (!this.pageArr.isEmpty()) {
            try {
                this.doMerge();
            }
            catch (DocumentException e) {
                throw new IOException(e);
            }
        }
        for (DocContext docContext : this.docCtxMap.values()) {
            docContext.close();
        }
    }
}

