/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.csv_entities;

import java.util.Arrays;
import java.util.List;
import org.onebusaway.csv_entities.TokenizerStrategy;

public class DelimiterTokenizerStrategy
implements TokenizerStrategy {
    private final String _delimiter;
    private boolean _replaceLiteralNullValues = false;

    public DelimiterTokenizerStrategy(String delimiter) {
        this._delimiter = delimiter;
    }

    public void setReplaceLiteralNullValues(boolean replaceLiteralNullValues) {
        this._replaceLiteralNullValues = replaceLiteralNullValues;
    }

    @Override
    public List<String> parse(String line) {
        String[] tokens = line.split(this._delimiter);
        if (this._replaceLiteralNullValues) {
            for (int i = 0; i < tokens.length; ++i) {
                String value = tokens[i].toLowerCase();
                if (!value.equals("null")) continue;
                tokens[i] = "";
            }
        }
        return Arrays.asList(tokens);
    }

    @Override
    public String format(Iterable<String> tokens) {
        StringBuilder b = new StringBuilder();
        boolean seenFirst = false;
        for (String token : tokens) {
            if (seenFirst) {
                b.append(this._delimiter);
            } else {
                seenFirst = true;
            }
            b.append(token);
        }
        return b.toString();
    }
}

