/*
 * Copyright (c) 2015, PostgreSQL Global Development Group
 * See the LICENSE file in the project root for more information.
 */

package org.opengauss.core;

/**
 * Contains parse flags from {@link Parser#modifyJdbcCall(String, boolean, int, int)}.
 */
public class JdbcCallParseInfo {
  private final String sql;
  private final boolean isFunction;
  private final boolean isACompatibilityFunction;

  public JdbcCallParseInfo(String sql, boolean isFunction, boolean isACompatibilityFunction) {
    this.sql = sql;
    this.isFunction = isFunction;
    this.isACompatibilityFunction = isACompatibilityFunction;
  }

  /**
   * SQL in a native for certain backend version.
   *
   * @return SQL in a native for certain backend version
   */
  public String getSql() {
    return sql;
  }

  /**
   * Returns if given SQL is a function.
   *
   * @return {@code true} if given SQL is a function
   */
  public boolean isFunction() {
    return isFunction;
  }

  public boolean isACompatibilityFunction() {
    return isACompatibilityFunction;
  }

}
