/*
  Copyright 2012 - 2015 pac4j organization

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */
package org.pac4j.http.profile.creator;

import org.pac4j.core.profile.UserProfile;
import org.pac4j.http.credentials.HttpCredentials;

/**
 * This profile creator retrieves the user profile attached with the {@link HttpCredentials}.
 * 
 * @author Jerome Leleu
 * @since 1.8.0
 */
public class AuthenticatorProfileCreator<C extends HttpCredentials, P extends UserProfile>
        implements ProfileCreator<C, P> {

    public final static AuthenticatorProfileCreator INSTANCE = new AuthenticatorProfileCreator<>();

    /**
     * {@inheritDoc}
     */
    @Override
    public UserProfile create(final HttpCredentials credentials) {
        return credentials.getUserProfile();
    }
}
