/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.direct;

import org.pac4j.core.client.ClientType;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.client.direct.DirectHttpClient;
import org.pac4j.http.credentials.TokenCredentials;
import org.pac4j.http.credentials.authenticator.TokenAuthenticator;
import org.pac4j.http.credentials.extractor.ParameterExtractor;
import org.pac4j.http.profile.creator.ProfileCreator;

public class ParameterClient
extends DirectHttpClient<TokenCredentials> {
    private String parameterName = "";
    private boolean supportGetRequest = false;
    private boolean supportPostRequest = true;

    public ParameterClient() {
    }

    public ParameterClient(String parameterName, TokenAuthenticator tokenAuthenticator) {
        this.parameterName = parameterName;
        this.setAuthenticator(tokenAuthenticator);
    }

    public ParameterClient(String parameterName, TokenAuthenticator tokenAuthenticator, ProfileCreator profileCreator) {
        this.parameterName = parameterName;
        this.setAuthenticator(tokenAuthenticator);
        this.setProfileCreator(profileCreator);
    }

    @Override
    protected void internalInit(WebContext context) {
        this.extractor = new ParameterExtractor(this.parameterName, this.supportGetRequest, this.supportPostRequest, this.getName());
        super.internalInit(context);
        CommonHelper.assertNotBlank((String)"parameterName", (String)this.parameterName);
    }

    protected ParameterClient newClient() {
        ParameterClient newClient = new ParameterClient();
        newClient.setParameterName(this.parameterName);
        newClient.setSupportGetRequest(this.supportGetRequest);
        newClient.setSupportPostRequest(this.supportPostRequest);
        return newClient;
    }

    public ClientType getClientType() {
        return ClientType.PARAMETER_BASED;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public boolean isSupportGetRequest() {
        return this.supportGetRequest;
    }

    public void setSupportGetRequest(boolean supportGetRequest) {
        this.supportGetRequest = supportGetRequest;
    }

    public boolean isSupportPostRequest() {
        return this.supportPostRequest;
    }

    public void setSupportPostRequest(boolean supportPostRequest) {
        this.supportPostRequest = supportPostRequest;
    }
}

