/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.extractor;

import java.util.Collection;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.http.credentials.TokenCredentials;
import org.pac4j.http.credentials.extractor.Extractor;

public class CookieExtractor
implements Extractor<TokenCredentials> {
    private final String cookieName;
    private final String clientName;

    public CookieExtractor(String cookieName, String clientName) {
        this.cookieName = cookieName;
        this.clientName = clientName;
    }

    @Override
    public TokenCredentials extract(WebContext context) {
        Collection col = context.getRequestCookies();
        for (Cookie c : col) {
            if (!c.getName().equals(this.cookieName)) continue;
            return new TokenCredentials(c.getValue(), this.clientName);
        }
        return null;
    }
}

