/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials;

import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.credentials.CredentialUtil;

public class DigestCredentials
extends TokenCredentials {
    private static final long serialVersionUID = -5130296967270874521L;
    private String username;
    private String realm;
    private String nonce;
    private String uri;
    private String cnonce;
    private String nc;
    private String qop;
    private String httpMethod;

    public DigestCredentials(String token, String httpMethod, String username, String realm, String nonce, String uri, String cnonce, String nc, String qop) {
        super(token);
        this.username = username;
        this.realm = realm;
        this.nonce = nonce;
        this.uri = uri;
        this.cnonce = cnonce;
        this.nc = nc;
        this.qop = qop;
        this.httpMethod = httpMethod;
    }

    public String calculateServerDigest(boolean passwordAlreadyEncoded, String password) {
        return this.generateDigest(passwordAlreadyEncoded, this.username, this.realm, password, this.httpMethod, this.uri, this.qop, this.nonce, this.nc, this.cnonce);
    }

    private String generateDigest(boolean passwordAlreadyEncoded, String username, String realm, String password, String httpMethod, String uri, String qop, String nonce, String nc, String cnonce) {
        String digest;
        String a2 = httpMethod + ":" + uri;
        String ha2 = CredentialUtil.encryptMD5(a2);
        String ha1 = passwordAlreadyEncoded ? password : CredentialUtil.encryptMD5(username + ":" + realm + ":" + password);
        if (qop == null) {
            digest = CredentialUtil.encryptMD5(ha1, nonce + ":" + ha2);
        } else if ("auth".equals(qop)) {
            digest = CredentialUtil.encryptMD5(ha1, nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + ha2);
        } else {
            throw new TechnicalException("Invalid qop: '" + qop + "'");
        }
        return digest;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DigestCredentials that = (DigestCredentials)((Object)o);
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        if (this.realm != null ? !this.realm.equals(that.realm) : that.realm != null) {
            return false;
        }
        if (this.nonce != null ? !this.nonce.equals(that.nonce) : that.nonce != null) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(that.uri) : that.uri != null) {
            return false;
        }
        if (this.cnonce != null ? !this.cnonce.equals(that.cnonce) : that.cnonce != null) {
            return false;
        }
        if (this.nc != null ? !this.nc.equals(that.nc) : that.nc != null) {
            return false;
        }
        if (this.qop != null ? !this.qop.equals(that.qop) : that.qop != null) {
            return false;
        }
        return !(this.httpMethod == null ? that.httpMethod != null : !this.httpMethod.equals(that.httpMethod));
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.realm != null ? this.realm.hashCode() : 0);
        result = 31 * result + (this.nonce != null ? this.nonce.hashCode() : 0);
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        result = 31 * result + (this.cnonce != null ? this.cnonce.hashCode() : 0);
        result = 31 * result + (this.nc != null ? this.nc.hashCode() : 0);
        result = 31 * result + (this.qop != null ? this.qop.hashCode() : 0);
        result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
        return result;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"username", this.username, "response", "[PROTECTED]"});
    }
}

