/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.reflect.internal.proxy;

import java.lang.reflect.Proxy;

public class ProxyFrameworks {
    public static final String CGLIB_CLASS_SEPARATOR = "$$";

    public Class<?> getUnproxiedType(Class<?> type) {
        if (type == null) {
            return null;
        }
        if (this.isJavaProxy(type)) {
            return type.getInterfaces()[0];
        }
        if (this.isCglibProxyClass(type)) {
            Class<?> superClass = type.getSuperclass();
            return type.getSuperclass();
        }
        return type;
    }

    private boolean isJavaProxy(Class<?> clazz) {
        return clazz != null && Proxy.isProxyClass(clazz);
    }

    public Class<?> getUnproxiedType(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        return this.getUnproxiedType(o.getClass());
    }

    public boolean isCglibProxyClass(Class<?> clazz) {
        return clazz != null && this.isCglibProxyClassName(clazz.getName());
    }

    public boolean isCglibProxyClassName(String className) {
        return className != null && className.contains(CGLIB_CLASS_SEPARATOR);
    }
}

