/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.boot.tenant;

import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import org.springblade.core.boot.tenant.BladeTenantHandler;
import org.springblade.core.boot.tenant.BladeTenantId;
import org.springblade.core.boot.tenant.BladeTenantInterceptor;
import org.springblade.core.boot.tenant.BladeTenantProperties;
import org.springblade.core.boot.tenant.TenantId;
import org.springblade.core.mp.config.MybatisPlusConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@AutoConfiguration
@AutoConfigureBefore(value={MybatisPlusConfiguration.class})
@EnableConfigurationProperties(value={BladeTenantProperties.class})
public class TenantConfiguration {
    @Bean
    @Primary
    public TenantLineHandler bladeTenantHandler(BladeTenantProperties tenantProperties) {
        return new BladeTenantHandler(tenantProperties);
    }

    @Bean
    @Primary
    public TenantLineInnerInterceptor tenantLineInnerInterceptor(TenantLineHandler tenantHandler) {
        BladeTenantInterceptor tenantInterceptor = new BladeTenantInterceptor();
        tenantInterceptor.setTenantLineHandler(tenantHandler);
        return tenantInterceptor;
    }

    @Bean
    @ConditionalOnMissingBean(value={TenantId.class})
    public TenantId tenantId() {
        return new BladeTenantId();
    }
}

