/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.boot.file;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import org.springblade.core.boot.file.BladeFileUtil;
import org.springblade.core.boot.file.IFileProxy;
import org.springblade.core.tool.constant.SystemConstant;
import org.springblade.core.tool.utils.DateUtil;
import org.springblade.core.tool.utils.ImageUtil;

public class BladeFileProxyFactory
implements IFileProxy {
    @Override
    public File rename(File f, String path) {
        File dest = new File(path);
        f.renameTo(dest);
        return dest;
    }

    @Override
    public String[] path(File f, String dir) {
        long time = System.nanoTime();
        StringBuilder uploadPath = new StringBuilder().append(BladeFileProxyFactory.getFileDir(dir, SystemConstant.me().getUploadRealPath())).append(time).append(BladeFileProxyFactory.getFileExt(f.getName()));
        StringBuilder virtualPath = new StringBuilder().append(BladeFileProxyFactory.getFileDir(dir, SystemConstant.me().getUploadCtxPath())).append(time).append(BladeFileProxyFactory.getFileExt(f.getName()));
        return new String[]{BladeFileUtil.formatUrl(uploadPath.toString()), BladeFileUtil.formatUrl(virtualPath.toString())};
    }

    public static String getFileExt(String fileName) {
        if (!fileName.contains(".")) {
            return ".jpg";
        }
        return fileName.substring(fileName.lastIndexOf("."));
    }

    public static String getFileDir(String dir, String saveDir) {
        StringBuilder newFileDir = new StringBuilder();
        newFileDir.append(saveDir).append(File.separator).append(dir).append(File.separator).append(DateUtil.format((Date)new Date(), (String)"yyyyMMdd")).append(File.separator);
        return newFileDir.toString();
    }

    @Override
    public void compress(String path) {
        try {
            ImageUtil.zoomScale((BufferedImage)ImageUtil.readImage((String)path), (OutputStream)new FileOutputStream(new File(path)), null, (double)SystemConstant.me().getCompressScale(), (boolean)SystemConstant.me().isCompressFlag());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

