/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.mp.base;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.validation.constraints.NotEmpty;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springblade.core.mp.base.BaseEntity;
import org.springblade.core.mp.base.BaseService;
import org.springblade.core.secure.BladeUser;
import org.springblade.core.secure.utils.SecureUtil;
import org.springblade.core.tool.utils.DateUtil;
import org.springblade.core.tool.utils.Func;
import org.springframework.validation.annotation.Validated;

@Validated
public class BaseServiceImpl<M extends BaseMapper<T>, T extends BaseEntity>
extends ServiceImpl<M, T>
implements BaseService<T> {
    public boolean save(T entity) {
        this.resolveSave(entity);
        return super.save(entity);
    }

    public boolean saveBatch(Collection<T> entityList, int batchSize) {
        entityList.forEach(this::resolveSave);
        return super.saveBatch(entityList, batchSize);
    }

    public boolean updateById(T entity) {
        this.resolveUpdate(entity);
        return super.updateById(entity);
    }

    public boolean updateBatchById(Collection<T> entityList, int batchSize) {
        entityList.forEach(this::resolveUpdate);
        return super.updateBatchById(entityList, batchSize);
    }

    @Override
    public boolean deleteLogic(@NotEmpty List<Long> ids) {
        return super.removeByIds(ids);
    }

    @Override
    public boolean isFieldDuplicate(SFunction<T, ?> field, Object value, Long excludedId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(field, value);
        if (excludedId != null) {
            queryWrapper.ne(BaseEntity::getId, (Object)excludedId);
        }
        return this.baseMapper.selectCount((Wrapper)queryWrapper) > 0L;
    }

    private void resolveSave(T entity) {
        BladeUser user = SecureUtil.getUser();
        if (user != null) {
            ((BaseEntity)entity).setCreateUser(user.getUserId());
            ((BaseEntity)entity).setCreateDept(Func.firstLong((String)user.getDeptId()));
            ((BaseEntity)entity).setUpdateUser(user.getUserId());
        }
        Date now = DateUtil.now();
        ((BaseEntity)entity).setCreateTime(now);
        ((BaseEntity)entity).setUpdateTime(now);
        if (((BaseEntity)entity).getStatus() == null) {
            ((BaseEntity)entity).setStatus(1);
        }
        ((BaseEntity)entity).setIsDeleted(0);
    }

    private void resolveUpdate(T entity) {
        BladeUser user = SecureUtil.getUser();
        if (user != null) {
            ((BaseEntity)entity).setUpdateUser(user.getUserId());
        }
        ((BaseEntity)entity).setUpdateTime(DateUtil.now());
    }
}

