/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.mp.support;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.sql.SQLException;
import java.util.Map;
import java.util.regex.Pattern;
import org.springblade.core.tool.utils.DateUtil;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.StringUtil;

public class SqlKeyword {
    private static final String SQL_REGEX = "(?i)(?<![a-z])('|%|--|insert|delete|select|sleep|count|updatexml|group|union|drop|truncate|alter|grant|execute|exec|xp_cmdshell|call|declare|sql)(?![a-z])";
    private static final Pattern PATTERN = Pattern.compile("(?:--|[\"';%]|\\binsert\\b|\\bdelete\\b|\\bselect\\b|\\bcount\\b|\\bupdatexml\\b|\\bsleep\\b|group\\s+by|\\bunion\\b|\\bdrop\\b|\\btruncate\\b|\\balter\\b|\\bgrant\\b|\\bexecute\\b|\\bxp_cmdshell\\b|\\bcall\\b|\\bdeclare\\b|\\bsql\\b)");
    private static final String SQL_INJECTION_MESSAGE = "SQL keyword injection prevention processing!";
    private static final String EQUAL = "_equal";
    private static final String NOT_EQUAL = "_notequal";
    private static final String LIKE = "_like";
    private static final String LIKE_LEFT = "_likeleft";
    private static final String LIKE_RIGHT = "_likeright";
    private static final String NOT_LIKE = "_notlike";
    private static final String GE = "_ge";
    private static final String LE = "_le";
    private static final String GT = "_gt";
    private static final String LT = "_lt";
    private static final String DATE_GE = "_datege";
    private static final String DATE_GT = "_dategt";
    private static final String DATE_EQUAL = "_dateequal";
    private static final String DATE_LT = "_datelt";
    private static final String DATE_LE = "_datele";
    private static final String IS_NULL = "_null";
    private static final String NOT_NULL = "_notnull";
    private static final String IGNORE = "_ignore";

    public static void buildCondition(Map<String, Object> query, QueryWrapper<?> qw) {
        if (Func.isEmpty(query)) {
            return;
        }
        query.forEach((k, v) -> {
            if (Func.hasEmpty((Object[])new Object[]{k, v}) || k.endsWith(IGNORE)) {
                return;
            }
            if ((k = SqlKeyword.filter(k)).endsWith(EQUAL)) {
                qw.eq((Object)SqlKeyword.getColumn(k, EQUAL), v);
            } else if (k.endsWith(NOT_EQUAL)) {
                qw.ne((Object)SqlKeyword.getColumn(k, NOT_EQUAL), v);
            } else if (k.endsWith(LIKE_LEFT)) {
                qw.likeLeft((Object)SqlKeyword.getColumn(k, LIKE_LEFT), v);
            } else if (k.endsWith(LIKE_RIGHT)) {
                qw.likeRight((Object)SqlKeyword.getColumn(k, LIKE_RIGHT), v);
            } else if (k.endsWith(NOT_LIKE)) {
                qw.notLike((Object)SqlKeyword.getColumn(k, NOT_LIKE), v);
            } else if (k.endsWith(GE)) {
                qw.ge((Object)SqlKeyword.getColumn(k, GE), v);
            } else if (k.endsWith(LE)) {
                qw.le((Object)SqlKeyword.getColumn(k, LE), v);
            } else if (k.endsWith(GT)) {
                qw.gt((Object)SqlKeyword.getColumn(k, GT), v);
            } else if (k.endsWith(LT)) {
                qw.lt((Object)SqlKeyword.getColumn(k, LT), v);
            } else if (k.endsWith(DATE_GE)) {
                qw.ge((Object)SqlKeyword.getColumn(k, DATE_GE), (Object)DateUtil.parse((String)String.valueOf(v), (String)"yyyy-MM-dd HH:mm:ss"));
            } else if (k.endsWith(DATE_GT)) {
                qw.gt((Object)SqlKeyword.getColumn(k, DATE_GT), (Object)DateUtil.parse((String)String.valueOf(v), (String)"yyyy-MM-dd HH:mm:ss"));
            } else if (k.endsWith(DATE_EQUAL)) {
                qw.eq((Object)SqlKeyword.getColumn(k, DATE_EQUAL), (Object)DateUtil.parse((String)String.valueOf(v), (String)"yyyy-MM-dd HH:mm:ss"));
            } else if (k.endsWith(DATE_LE)) {
                qw.le((Object)SqlKeyword.getColumn(k, DATE_LE), (Object)DateUtil.parse((String)String.valueOf(v), (String)"yyyy-MM-dd HH:mm:ss"));
            } else if (k.endsWith(DATE_LT)) {
                qw.lt((Object)SqlKeyword.getColumn(k, DATE_LT), (Object)DateUtil.parse((String)String.valueOf(v), (String)"yyyy-MM-dd HH:mm:ss"));
            } else if (k.endsWith(IS_NULL)) {
                qw.isNull((Object)SqlKeyword.getColumn(k, IS_NULL));
            } else if (k.endsWith(NOT_NULL)) {
                qw.isNotNull((Object)SqlKeyword.getColumn(k, NOT_NULL));
            } else {
                qw.like((Object)SqlKeyword.getColumn(k, LIKE), v);
            }
        });
    }

    private static String getColumn(String column, String keyword) {
        return StringUtil.humpToUnderline((String)StringUtil.removeSuffix((CharSequence)column, (CharSequence)keyword));
    }

    public static String filter(String param) {
        if (param == null) {
            return null;
        }
        String sql = param.replaceAll(SQL_REGEX, "");
        if (SqlKeyword.match(sql).booleanValue()) {
            throw new SQLException(SQL_INJECTION_MESSAGE);
        }
        return sql;
    }

    public static Boolean match(String param) {
        return Func.isNotEmpty((Object)param) && PATTERN.matcher(param).find();
    }
}

