/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.tool.sensitive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.springblade.core.tool.sensitive.SensitiveConfig;
import org.springblade.core.tool.sensitive.SensitiveType;
import org.springblade.core.tool.sensitive.SensitiveWord;
import org.springblade.core.tool.utils.CollectionUtil;
import org.springblade.core.tool.utils.StringUtil;

public class SensitiveUtil {
    private static final String DEFAULT_REPLACEMENT = "******";
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final SensitiveConfig DEFAULT_CONFIG = SensitiveConfig.builder().sensitiveTypes(EnumSet.of(SensitiveType.MOBILE, SensitiveType.ID_CARD, SensitiveType.EMAIL, SensitiveType.BANK_CARD)).sensitiveWords(EnumSet.of(SensitiveWord.SECURE, SensitiveWord.AUTHENTICATION)).processLineByLine(true).replacement("******").build();

    public static String process(String content) {
        return SensitiveUtil.process(content, DEFAULT_CONFIG);
    }

    public static String process(String content, SensitiveConfig config) {
        String placeholder;
        if (StringUtil.isBlank(content)) {
            return content;
        }
        String processedContent = content;
        String string = placeholder = StringUtil.isBlank(config.getReplacement()) ? DEFAULT_REPLACEMENT : config.getReplacement();
        if (!CollectionUtil.isEmpty(config.getSensitiveTypes())) {
            processedContent = SensitiveUtil.processRegexPatterns(processedContent, config.getSensitiveTypes());
        }
        if (!CollectionUtil.isEmpty(config.getCustomPatterns())) {
            processedContent = SensitiveUtil.processCustomPatterns(processedContent, config.getCustomPatterns(), placeholder);
        }
        if (!CollectionUtil.isEmpty(config.getSensitiveWords())) {
            List<String> words = SensitiveUtil.getSensitiveWords(config.getSensitiveWords());
            processedContent = SensitiveUtil.processSensitiveWords(processedContent, words, placeholder, config.isProcessLineByLine());
        }
        return processedContent;
    }

    public static String process(String content, SensitiveType type) {
        if (StringUtil.isBlank(content) || type == null) {
            return content;
        }
        return SensitiveUtil.processRegexPatterns(content, Collections.singleton(type));
    }

    public static String process(String content, Set<SensitiveType> types) {
        if (StringUtil.isBlank(content) || CollectionUtil.isEmpty(types)) {
            return content;
        }
        return SensitiveUtil.processRegexPatterns(content, types);
    }

    public static String processWithRegex(String content, String regex) {
        return SensitiveUtil.processWithRegex(content, regex, DEFAULT_REPLACEMENT);
    }

    public static String processWithRegex(String content, String regex, String replacement) {
        if (StringUtil.isBlank(content) || StringUtil.isBlank(regex)) {
            return content;
        }
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(content).replaceAll(replacement);
    }

    public static String processWithWords(String content, List<String> words) {
        return SensitiveUtil.processWithWords(content, words, DEFAULT_REPLACEMENT, true);
    }

    public static String processWithWords(String content, List<String> words, String placeholder, boolean processLineByLine) {
        if (StringUtil.isBlank(content) || CollectionUtil.isEmpty(words)) {
            return content;
        }
        return SensitiveUtil.processSensitiveWords(content, words, placeholder, processLineByLine);
    }

    private static String processRegexPatterns(String content, Set<SensitiveType> types) {
        String result = content;
        for (SensitiveType type : types) {
            result = type.replaceAll(result);
        }
        return result;
    }

    private static String processCustomPatterns(String content, Map<String, Pattern> patterns, String placeholder) {
        String result = content;
        for (Pattern pattern : patterns.values()) {
            result = pattern.matcher(result).replaceAll(placeholder);
        }
        return result;
    }

    private static List<String> getSensitiveWords(Set<SensitiveWord> groups) {
        ArrayList<String> words = new ArrayList<String>();
        for (SensitiveWord group : groups) {
            words.addAll(group.getWords());
        }
        return words;
    }

    private static String processSensitiveWords(String content, List<String> words, String placeholder, boolean processLineByLine) {
        return processLineByLine ? SensitiveUtil.maskSensitiveLines(content, words, placeholder) : SensitiveUtil.maskSensitiveContent(content, words, placeholder);
    }

    private static String maskSensitiveLines(String content, List<String> words, String placeholder) {
        String[] lines = content.split(LINE_SEPARATOR);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            boolean containsSensitive = words.stream().anyMatch(word -> line.toLowerCase().contains(word.toLowerCase()));
            result.append(containsSensitive ? placeholder : line);
            if (i >= lines.length - 1) continue;
            result.append(LINE_SEPARATOR);
        }
        return result.toString();
    }

    private static String maskSensitiveContent(String content, List<String> words, String placeholder) {
        boolean containsSensitive = words.stream().anyMatch(word -> content.toLowerCase().contains(word.toLowerCase()));
        return containsSensitive ? placeholder : content;
    }
}

