/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.ollama.metadata;

import java.util.Optional;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.ollama.api.OllamaApi;
import org.springframework.util.Assert;

public class OllamaChatUsage
implements Usage {
    protected static final String AI_USAGE_STRING = "{ promptTokens: %1$d, generationTokens: %2$d, totalTokens: %3$d }";
    private final OllamaApi.ChatResponse response;

    public OllamaChatUsage(OllamaApi.ChatResponse response) {
        this.response = response;
    }

    public static OllamaChatUsage from(OllamaApi.ChatResponse response) {
        Assert.notNull((Object)response, (String)"OllamaApi.ChatResponse must not be null");
        return new OllamaChatUsage(response);
    }

    public Long getPromptTokens() {
        return Optional.ofNullable(this.response.promptEvalCount()).map(Integer::longValue).orElse(0L);
    }

    public Long getGenerationTokens() {
        return Optional.ofNullable(this.response.evalCount()).map(Integer::longValue).orElse(0L);
    }

    public String toString() {
        return AI_USAGE_STRING.formatted(this.getPromptTokens(), this.getGenerationTokens(), this.getTotalTokens());
    }
}

