/*
 * Copyright 2012-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.boot.test.autoconfigure.restdocs;

import org.springframework.restdocs.mockmvc.MockMvcRestDocumentationConfigurer;

/**
 * A customizer for {@link MockMvcRestDocumentationConfigurer}. If a
 * {@code RestDocsMockMvcConfigurationCustomizer} bean is found in the application context
 * it will be {@link #customize called} to customize the
 * {@code MockMvcRestDocumentationConfigurer} before it is applied. Intended for use only
 * when the attributes on {@link AutoConfigureRestDocs} do not provide sufficient
 * customization.
 *
 * @author Andy Wilkinson
 * @since 1.4.0
 */
public interface RestDocsMockMvcConfigurationCustomizer {

	/**
	 * Customize the given {@code configurer}.
	 * @param configurer the configurer
	 */
	void customize(MockMvcRestDocumentationConfigurer configurer);

}
